/* bits - a program for editing rasters and fonts - main program.
 * Copyright (c) Per Bothner, March 1983.
 */
#include <rasterops.h>
#include <m68000.h>
#include "bits.h"
#include <text.h>
#include <Vquerykernel.h>
extern MemRaster *GetRaster(), *Update(), *AdjustEdges();
extern DoInvert(), DoGetChar(), DoSaveCopy(), DoRedraw(), Quit(),
    PutRaster(), DoReadRaster(), LoadFont(), WriteFont(), ChangeSize(),
    GetNameTab(), Store(), DoRasterOp(), SetTFM(), DoAssign(), DoTransform(),
    SetTFMfield(), SetDescent(), CalculateDescentAndHeight(), ChangeWidth();
GETCHAR() {int c;Flush(stdout);c=getchar();putchar(c);Flush(stdout);return c;}
extern MemRaster WholeFB, EmpRaster, InvEmpRaster;
char name[100]; /* temp. string buffer */
extern char ResolutnStr[];
MemRaster *r;
int c;
#define getint() (c = 0, Getint())
short scale = Scale8+ScaleFramed;
#define CTRL(x) (x&0x1F)

char curCharStr[5] = " '?'";
char curFontName[40] = "--unknown--\000";
long curWidth = 32, curHeight = 16, curTFMwidth = 0;
double curDispl[2] = {0, 0};
int curChar = 0, charValid = 0;
unsigned char SampleText[68] = "--none--\000";
char InvertStr[4];

#define RowChar 2
#define ColChar 41
#define RowFontParams 6
#define RowNameTab 11
#define ColNameTab 1
#define MaxNameTab 6
#define EmptyName "                           "
#define MaxNameLen 25
#define FNameTab0 3
#define RowEnd 22
#define AssignFields (MaxNameTab+7)
Field MenuPad[] =
  { /* don't rearrange this table without checking ALL calls of GetField */
 /* The first FNameTab0 fields are valid RasterOp sources */
    {17, 1, 18,  VAL &EmpRaster,   GetNameTab,	"[Get empty raster]"},
    {17,19, 17,  VAL &WholeFB,     GetNameTab,	"[Get framebuffer]"},
    {RowNameTab-1, ColNameTab, 0, 0,0,	 "-- Table of saved rasters --"},
 /* The next NamesCount fields are valid for both RasterOp and Assogn */
    {RowNameTab+0, ColNameTab, 0, 0,GetNameTab, "(None, so far!)            "},
    {RowNameTab+1, ColNameTab, 0, 0,GetNameTab, EmptyName},
    {RowNameTab+2, ColNameTab, 0, 0,GetNameTab, EmptyName},
    {RowNameTab+3, ColNameTab, 0, 0,GetNameTab, EmptyName},
    {RowNameTab+4, ColNameTab, 0, 0,GetNameTab, EmptyName},
    {RowNameTab+5, ColNameTab, 0, 0,GetNameTab, EmptyName},
 /* The next AssignFields-MaxNameTab fields can be Assigned to */
    {RowChar-1, ColChar, 0, 0,	   0,		"--- Current character ---"},
    {RowChar, ColChar, 5, VAL  curCharStr,	DoGetChar, "%s ="},
    {RowChar, ColChar+6, 10,	&curChar,	DoGetChar, " %3o(oct) ="},
    {RowChar, ColChar+17, 10,	&curChar,	DoGetChar, " %3d(dec) ="},
    {RowChar, ColChar+28, 9,	&curChar,	DoGetChar, " %2x(hex)."},
    {RowChar+1, ColChar, 6,	VAL 1,	DoGetChar, "[Next]"},
    {RowChar+1, ColChar+10, 6,	VAL -1,	DoGetChar, "[Prev]"},
    {RowChar+1, ColChar+19, 20, &curTFMwidth, SetTFM, "TFM width: %-9d"},
    {RowChar+2, ColChar, 0,    0, 0, 		"Displacement:"},
    {RowChar+2, ColChar+13, 11, VAL &curDispl[Y], ChangeWidth, "%10lg *"},
    {RowChar+2, ColChar+25, 11, VAL &curDispl[X], ChangeWidth, " %-10lg"},
    {1,  1, -1,	 0,	 	   0,		"---- Current raster ---- "},
    {3,  1, 29,  VAL InvertStr,	   DoInvert, "[Invert black and white? %s.]"},
    {2,  1, 13,	 &curHeight,	   ChangeSize,	"[Height:%3d] "},
    {2, 16, 12,  &curWidth,	   ChangeSize,	"[Width:%3d] "},
    {18, 1, 21,	 0,		   Store,	"[Store with new name]"},
    {18,22, 18,  0,		   DoAssign,	"[Replace in table]"},
    {19, 1, 17,  0,		   DoTransform,	"[Reflect/rotate]"},
    {19,19, 18,  0,		   DoRasterOp,	"[Raster operation]"},
    {20, 1, 17,	 0,		   DoSaveCopy,	"[Make fresh copy]"},
    {20, 19, 8,	 0,		   DoRedraw,	"[Redraw] "},
    {20, 28, 6,	 0,		   Quit,	"[Quit]"},
    {6, 1, 0, 	 0, 		   0,	  "-- Read raster | Write raster --"},
    {7, 1, 6,	 0,		   DoReadRaster,"  []   .sun bitmap format"},
    {7, 29, 6,   0,		   PutRaster,	"  []  "},
    {8, 5, 28,   VAL 1,	           PutRaster,"hex (C-compatible) format [] "},
    {RowChar+4, ColChar, 0, VAL curFontName, 0, "Current font: %-25.25s"},
    {8, 41, 0,	 0,		   0,	"----  Read font | Write font ----"},
    {9, 41, 6,   VAL SfFile,	   LoadFont,	"  []     sf (sun) format"},
    {9, 68, 6,   VAL SfFile,	   WriteFont,	"  [] "},
    {10, 41, 6,  VAL SfArchive,    LoadFont,   "  []   archive of sf. fonts"},
    {11, 41, 6,  VAL PxlFile,      LoadFont,	"  []    pxl (TeX) format"},
    {11, 68, 6,  VAL PxlFile,      WriteFont,	"  [] "},
    {12, 41, 6,  VAL GfFile,       LoadFont,	"  []   MetaFont gf format"},
    {12, 68, 6,  VAL GfFile,	   WriteFont,	"  [] "},
    {14, 41, 0,  0,		   0,		"--- Font parameters ---"},
    {15, 41, 0,  0,		   0,		"Character range:"},
    {15, 57, 4,  VAL &minChar,     ReadStdFld,	" %3hd-"},
    {15, 62, 4,  VAL &maxChar,     ReadStdFld,	"%-3hd"},
    {16, 41, 0,  0,		   0,		"Max."},
    {16, 45, 12, VAL &Height,	   ReadStdFld,	" height:%3hd, "},
    {16, 59, 12, VAL &Descent,     SetDescent,	"descent:%3hd. "},
    {17, 41, 19, VAL &CharAlign,   ReadStdFld,	"Raster alignment: %hd "},
    {18, 41, 25, VAL ResolutnStr,  SetTFMfield,	"Resolution: %.20S"},
    {19, 41, 25, VAL &DesignSize,  SetTFMfield,	"Design Size: %gpt      "},
    {21, 1, 80,	 VAL SampleText,   NewSample,	"Sample text: %s"},
    LASTFIELD
  };

static PopUpEntry RasterOpMenu[] =
  {
    "Invert Source",		0,
    "Invert Destination",	1,
    "Copy",			GXcopy,
    "Or (Paint) to destination",GXpaint,
    "And to destination",	GXand,
    "Xor into destination",	GXxor,
    0, 0
  };

static NamesCount = 0;
MemRaster *curRaster;
/* invariant: if (charValid) curRaster == FontTab[curChar].raster */
short sdf, vgt, x=0, y=0, buttons=0, oldButtons=0;
char cbuf[30]; File vgtFile;
int GXBase = 0;
# define Sun2GXDefaultBase 0xFC0000	/* Default location of Sun-1
					 * framebuffer in a Sun-2 */
int function, i;
main()
  {
    SetVgtBanner(stdin, "bits      -- A font and bitmap editor --");
    GetTTY(); SetGXBase();

    sdf = CreateSDF();
    DefineSymbol(sdf, TopItem, 0);
    AddItem(sdf,OutlineItem, 0, 10, 0, 10, 0, SDF_OUTLINE, 0);
    EndSymbol(sdf, TopItem, 0);
    vgt = CreateVGT(sdf, GRAPHICS+ZOOMABLE, 1, "Bits (current raster)");
    /* CreateView(vgt, 16, 10, 612, 350, -2, -2, Scale8, 1); */
    ModifyPad(stdin, ReportTransition+LF_Output+NoCursor); 
    printf("[Use the mouse to outline a view]\r\n");
    Flush(stdout); RedrawPad(stdout);
    DefaultView(vgt, 0, 0, -4, -4, Scale8, 1, 0, 0);
    fputc(CTRL('L'), stdout);
    vgtFile.fileserver = stdin->fileserver;
    vgtFile.fileid = vgt;
    ClearFont();
    curRaster = 0; UpdateChar('A'); Update(SubRaster(0, 0, 0, 0, 16, 32));

    for ( ; ; )
      {
	printf("\033[%d;1H", RowEnd);
        oldButtons = buttons;
	c=GetEvent(stdin,&x,&y,&buttons,cbuf);
	if (c < 0) {printf("Mouse Error!"); Flush(stdout);continue;}
	if (c > 0) { c = *cbuf; DoAction(); continue;}
	if (buttons!=GetMouseStatus(&vgtFile,&x,&y,0))
	  { Field *field =
	    GetField(MenuPad, 999, buttons, stdout);
	    printf("\033[%d;1H\033[J", RowEnd);
	    if (field) 
	        (*(field->proc))(field, stdout, stdin);
	    continue;
	  }

	if (buttons == MiddleButton)
	  { int edges=0;
	    if (AdjustCharAttr()) continue;
	    if (x==-1) edges+=LeftEdge;
	    if (y==-1) edges+=BottomEdge;
	    if (x==curRaster->width) edges+=RightEdge;
	    if (y==curRaster->height) edges+=TopEdge;
	    if (edges) { AdjustEdges(edges); continue;}
	    /* ... else fall through ... */
	  }
	if ((buttons == LeftButton || buttons == MiddleButton)
	    && (curRaster->where & MemoryRaster))
	  { int old, new = buttons==LeftButton;
	    while (buttons==GetMouseStatus(&vgtFile,&x,&y,0))
	      {
	        old = ChangeBit(curRaster, x, curRaster->height - 1 - y, new);
		if (new == !old && old >= 0) Show(curRaster);
	      }
	    continue;
	  }
/*printf("(No action:%o:%d)",c,buttons);Flush(stdout); RedrawPad(stdout); */
      }
  }

DoAction()
  {
    switch(c)
     {
	case '\r': putchar(c); c = '\n'; /* fall thru ... */
	case '\n': DoRedraw(); return;
	case '?': Statistics(curRaster); return;
	case CTRL('C'): case CTRL('D'): case CTRL('Z'):
	    Quit();
	default:
	    printf("[Got character: %oo]",c); c &= 0x7F;
      }
  }
DoRasterOp()
  {
    Field *field; MemRaster *r;
    int invSrc = 0, invDst = 0; short function;
  askOp:
    c = popup(RasterOpMenu);
    if (c < 0) return;
    if (c == 0) {invSrc = !invSrc; goto askOp;}
    if (c == 1) {invDst = !invDst; goto askOp;}
    function = c;
    if (invSrc) {d0=function;function=InvertSource();}
    if (invDst) {d0=function;function=InvertDest();}
    printf("(Select a source from the name table)");
    fflush(stdout); RedrawPad(stdout);
    field = GetField(MenuPad, FNameTab0+NamesCount, 0, stdout);
    if (field)
      {
        RasterOp(curRaster, field->value,  function);
	DoRedraw();
      }
  }
	
SelectChar(field)
    Field *field;
  { char old = curChar; int c;
    if ((int)field->value == -1)
      {
	for (c = curChar-1; c >=0; c--) 
	    if (FontTab[c].status != NullChar) return c;
	for (c = 255; c > curChar; c--)
	    if (FontTab[c].status != NullChar) return c;
	return (c - 1) & 0xFF;
      }
    else if ((int)field->value == 1)
      {
	for (c = curChar+1; c <= 255; c++)
	    if (FontTab[c].status != NullChar) return c;
	for (c = 0; c < curChar; c++)
	    if (FontTab[c].status != NullChar) return c;
	return (c + 1) & 0xFF;
      }
    else if ((char *)field->value == curCharStr) return GETCHAR();
    else
      { 
	if (ReadStdFld(field) < 1) {curChar = old; return -1;}
	c = curChar & 0xFF; curChar = old; return c;
      }
  }
DoGetChar(field)
    Field *field;
  { MemRaster *r; c = SelectChar(field);
    if (c < 0) return;
    UpdateChar(c);
    if (!LoadChar) r = FontTab[c].raster;
    else r = (*LoadChar)(c);
    Update(r);
  }
DoInvert()
  { MemRaster *r;
    if (curRaster==&EmpRaster) r = &InvEmpRaster;
    else if (curRaster==&InvEmpRaster) r = &EmpRaster;
    else {r = GetNewLink(curRaster); r->where ^= InverseRaster;}
    Update(r);
  }
GetNameTab(field)
    Field *field;
  { MemRaster *r = (MemRaster *)field->value;
    if (r)
      {
        if (r->where & LinkedRaster) r = GetNewLink(r);
	UpdateChar(-1); Update(r);
      }
    if (r == &WholeFB)
      {
        printf(
"\033[%d;1HNOTE: Since the frame-buffer is so large, you might want to\nadjust its size before clicking [Save fresh copy].\n", RowEnd);
	fflush(stdout);
      }
  }

Store()
  { int i; char *s;
    if (NamesCount >= MaxNameTab)
        {fprintf(stderr, "No more names!\n"); fflush(stderr);return;}
    printf("Type name to remember raster as: ");
    if (!GetString()) return;
    s = MenuPad[FNameTab0+NamesCount].format;
    *s++ = '[';
    StrToFormat(s, name, MaxNameLen - 3);
    strcat(s, "]");
    MenuPad[FNameTab0+NamesCount].width = strlen(name) + 2;
    MenuPad[FNameTab0+NamesCount].value = (int *)(GetNewLink(curRaster));
    NamesCount++;
    DoRedraw();
  }
DoAssign()
  { Field *field;
    printf("(Select a name table entry or character to replace)\n");
    fflush(stdout); RedrawPad(stdout);
    field = GetField(MenuPad+FNameTab0, AssignFields, 0, stdout);
    if (field == NULL) return;
    if (field->proc == DoGetChar)
      { int ch = SelectChar(field);
	if (ch >= 0)
	  { register struct CharData *fPtr = FontTab + ch;
	    FreeMemRaster(fPtr->raster);
	    fPtr->raster = GetNewLink(curRaster);
	    fPtr->status = InCoreChar;
	    fPtr->bBox[Y] = curRaster->height;
	    fPtr->bBox[X] = curRaster->width;
	    fPtr->origin[X] = 0; fPtr->origin[Y] = 0;
	  }
      }
    else if (curRaster == &EmpRaster)
      { /* delete the selected element from the table */
	FreeMemRaster((MemRaster*)field->value);
        for ( ; field < MenuPad+FNameTab0+MaxNameTab-1; field++)
	  {
	    field->value = (field+1)->value;
	    field->width = (field+1)->width;
	    strcpy(field->format, (field+1)->format);
	  }
	field->width = 0;
	field->value = NULL;
	strcpy(field->format, EmptyName);
	NamesCount--;
      }
    else
      {
	FreeMemRaster((MemRaster*)field->value);
	field->value = (int*)GetNewLink(curRaster);
      }
    DoRedraw();
  }

Getint() { int n=0, negative;
    while (!c || c==' '||c=='\t') c=GETCHAR();
    if (negative = c == '-') c=GETCHAR();
    while(c >='0' && c<='9') {n *= 10; n+= c - '0'; c = GETCHAR();}
    return negative ? -n : n;
}
DoRedraw()
  { MemRaster *r = curRaster;
    if (SampleVgt >= 0) UpdateSample();
    if (charValid && LoadChar) r = (*LoadChar)(curChar);
    curRaster = 0; UpdateChar(charValid ? curChar : -1); Update(r);
  }
DoSaveCopy()
  { MemRaster *r = UniqueCopy(curRaster);
    UpdateChar(-1); Update(r);
  }

MemRaster *
AdjustSize(dx, dy, h, w)
  { MemRaster *r = SubRaster(0, curRaster, dx, dy, h, w);
    if (charValid)
      { register struct CharData *fPtr = FontTab+curChar;
        fPtr->origin[X] -= dx;
	fPtr->origin[Y] -= dy;
	fPtr->bBox[X] = w;
	fPtr->bBox[Y] = h;
	FreeMemRaster(curRaster);
	if (fPtr->raster == &EmpRaster)
	  { fPtr->raster = r; fPtr->status = InCoreChar; }
	CalculateDescentAndHeight();
	UpdateChar(curChar);
      }
    return Update(r);
  }
ChangeSize(field)
    Field *field;
  {
    int i, h = curRaster->height, w = curRaster->width, dx = 0, dy = 0;
    if (ReadStdFld(field) < 1) return 0;
    i = *field->value;
    if (field->value == &curWidth) /* change width */
       if (i >= 0) w = i;
       else {dx = w + i; w = -i;}
    else /* field->value == &curHeight => change height */
       if (i >= 0) h = i;
       else {dy = h + i; h = -i;}
    AdjustSize(dx, dy, h, w);
  }
ChangeWidth(field)
    Field *field;
  { int coord = (long)field->value == (long)&curDispl[1];
    if (ReadStdFld(field) < 1) return 0;
    FontTab[curChar].width[coord] = curDispl[coord] * 65536.0 + 0.5; 
  }
SetTFM(field)
  {
    if (ReadStdFld(field) < 1) curTFMwidth = FontTab[curChar].TFMwidth;
    FontTab[curChar].TFMwidth = curTFMwidth;
  }
DoReadRaster()
  {
    UpdateChar(-1); Update(GetRaster());
  }
Quit()
  {
    DeleteVGT(vgt,1); DeleteVGT(SampleVgt,1);
    DeleteSDF(sdf);
    ResetTTY();
    exit();
  }

ShowBaselineItem(x, y, redraw)
  {
    if (redraw) EditSymbol(sdf,TopItem);
    DeleteItem(sdf, yBaseItem);
    AddItem(sdf, yBaseItem, -3, -1, y, y, 0, SDF_HORIZONTAL_LINE, 0);
    if (redraw) EndSymbol(sdf, TopItem, vgt);
  }

ShowXstartItem(x, y, redraw)
  {
    if (redraw) EditSymbol(sdf,TopItem);
    DeleteItem(sdf, xStartItem);
    y = curRaster->height;
    AddItem(sdf, xStartItem, x, x, y, y+2, 0, SDF_VERTICAL_LINE, 0);
    if (redraw) EndSymbol(sdf, TopItem, vgt);
  }

ShowWidthItem(x, y, redraw)
  {
    if (redraw) EditSymbol(sdf,TopItem);
    DeleteItem(sdf, WidthItem);
    AddItem(sdf, WidthItem, x, x, -3, -1, 0, SDF_VERTICAL_LINE, 0);
    if (redraw) EndSymbol(sdf, TopItem, vgt);
  }

ShowHeightItem(x, y, redraw)
  {
    x = curRaster->width;
    if (redraw) EditSymbol(sdf,TopItem);
    DeleteItem(sdf, HeightItem);
    AddItem(sdf, HeightItem, x, x+2, y, y, 0, SDF_HORIZONTAL_LINE, 0);
    if (redraw) EndSymbol(sdf, TopItem, vgt);
  }

Show(r)
    register MemRaster *r;
    /* update the VGT to display raster 'r' */
  {
    EditSymbol(sdf, TopItem);

    DeleteItem(sdf,RasterItem);
    if (r && ((r->where & ~InverseRaster) == IsFbRaster))
        AddItem(sdf, RasterItem, 0, 99, 0, 16, 0,
	    SDF_SIMPLE_TEXT, "<Frame buffer raster>");
    else if (!r || !(r->where & MemoryRaster))
        AddItem(sdf, RasterItem, 0, 99, 0, 16, 0, SDF_SIMPLE_TEXT,
	    !r || !(r->where&InverseRaster) ? "<Empty raster>"
	    : "<Black empty raster>");
    else
      { int temp = r->bitOffset || r->height != r->stride;
	if (temp) r = UniqueCopy(r);
        AddItem(sdf, RasterItem, 0, r->width-1, 0, r->height-1,
	    r->where&InverseRaster, SDF_RASTER, r->start);
        if (temp) FreeRaster(r);
      }
    if (r)
      ChangeItem(sdf, OutlineItem, -1, r->width, -1, r->height,
	AllEdges, SDF_OUTLINE, 0);

    DeleteItem(sdf, ProofItem);
    if (charValid)
      { int x, y, i; register struct CharData *tabP = &FontTab[curChar];
	x = tabP->origin[X];
	y = r->height - tabP->origin[Y];
	if ((i = tabP->proofItem) >= 0)
	    AddCall(sdf, ProofItem, x, y, i);
	ShowBaselineItem(0, y, 0);
	ShowXstartItem(x, 0, 0);
	ShowWidthItem(x + (tabP->width[X]>>16), 0, 0);
	ShowHeightItem(0, y - (tabP->width[Y]>>16), 0);
      }
    else
      {
	DeleteItem(sdf, yBaseItem);
	DeleteItem(sdf, HeightItem);
	DeleteItem(sdf, xStartItem);
	DeleteItem(sdf, WidthItem);

      }
    EndSymbol(sdf, TopItem, vgt);
  }

char *
GetString()
    /* read string from keyboard. If BELL, abort and return 0, else string. */
  { int length; char *s = name; char ch;
    ModifyPad(stdin, LineBuffer+Echo+LF_Output+CR_Input); 
    if (scanf("%90[^\007\n\r]", name) < 1) *name = 0;
    scanf("%c", &ch);
    ModifyPad(stdin, ReportTransition+LF_Output+NoCursor);
    if (ch == CTRL('G'))
      {printf("\007---Aborted---\r\n"); Flush(stdout); *name = 0; return 0;}
    else return name;
  }
MemRaster *
GetRaster()
  { File *f; register MemRaster *r; int i; short h, w;
    printf("File to read in .sun format: ");
    if (!GetString()) return(0);
    f = fopen(name, "r");
    if (f <= 0) {strcat(name, ".sun"); f = fopen(name, "r");}
    if (f <= 0) {printf("!not Open!"); Flush(stdout); return(0);}
    r = (MemRaster*)(malloc(sizeof(MemRaster)));
    fseek(f, 4, 1);
    fread(&h, 2, 1, f);
    fread(&w, 2, 1, f);
    r = SubRaster(0, 0, 0, 0, h, w);
/*
    r->stride = r->height;
    r->bitOffset = 0;
    r->where = HeadRaster+LinkedRaster+MemoryRaster;
    r->next = r;
    i = r->height * ((r->width + 15) >> 4) << 1;
    r->start = (short*)(malloc(i));
*/
    fread(r->start, i, 1, f);
    fclose(f);
    return(r);
  }

PutRaster(field)
    Field *field;
  { int inHex = (int)field->value;
    /* write raster to file, in one of two formats:
     * inhex=0: .sun format
     * inhex=1: hex text that can be compiled by c.
     */
    register MemRaster *r = curRaster;
    File *f; int i, temp;
    if (!inHex) printf("File to write in .sun format: ");
    else printf("File to write to in hex: ");
    if (GetString() == NULL) return(0);
    f = fopen(name,"w");
    if (f <= 0) {printf("!not Open!");Flush(stdout);return(0);}
    i = r->height * ((r->width + 15) >> 4) << 1;
    if (temp = (r->bitOffset || r->height != r->stride)) {
       r = RasterOp(0, r, GXcopy);
    }
    if (!inHex)
      {
	putc(157,f); putc(3,f); putc(0,f); putc(1,f);
	putc((r->height) >> 8, f);
	putc((r->height) & 0xFF, f);
	putc((r->width) >> 8, f);
	putc((r->width) & 0xFF, f);
	fwrite(r->start, i, 1, f);
      }
    else
      { register unsigned short *p = (unsigned short *)(r->start);
        register int j; i >>= 1;
	for (j = 0; ++j <= i; )
	  { register w = *p++;
	    fprintf(f," 0x%02x,0x%02x", (w>>8)&0xFF, w&0xFF);
	    if (j<i) putc(',', f);
	    if (j>=i || !(j&7)) putc('\n',f);
	  }
      }
    if(temp) FreeRaster(r);
    fclose(f);
    return(1);
  }

Statistics(r)
    register MemRaster *r;
  { int i; register MemRaster *q;
    printf("Raster data: height: %d, width: %d.%s\n",
	r->height, r->width, r->where&InverseRaster ? "Inverted" : "");
    if (r->where&MemoryRaster)
	printf("\t[bitoffset: %d, stride: %d, start-address: %x]\n",
	    r->bitOffset, r->stride, r->start);
    if (r->where&LinkedRaster)
      { 
	for ((q = r->next, i = 0); q != r; q = q->next) i++;
	printf("\t%s. Other rasters pointing at same bitmap: %d.\n",
	    r->where&HeadRaster ? "HeadRaster" : "SubRaster",
	    i);
      }
    Flush(stdout);
	
  }

UpdateChar(ch)
  { char *s;
    if (charValid) curRaster = 0; /* so Update doesn't free it */
    charValid = ch >= 0;
    if (charValid) curChar = ch;
    s = curCharStr;
    if (curChar >= ' ' && curChar <= 126) sprintf(s, " '%c'", curChar);
    else if (curChar < ' ') sprintf(s, "'^%c'", curChar+'@');
    else strcpy(s, "'??'");
    if (!charValid)
      { curTFMwidth = 0; curDispl[X] = 0.0; curDispl[Y] = 0.0;}
    else
      {
	curTFMwidth = FontTab[curChar].TFMwidth;
	curDispl[Y] = FontTab[curChar].width[Y] / 65536.0;
	curDispl[X] = FontTab[curChar].width[X] / 65536.0;
      }
  }
UpdatePad()
  { int i;
    printf("\033[H");
    for (i = RowEnd; --i > 0; ) printf("\033[K\n");
    DisplayFields(MenuPad, 999, stdout);
  }
MemRaster *
Update(r)
    MemRaster *r;
  { int i;
    if (!r) return(0);
    if (!curRaster|| r->width!=curRaster->width || r->height!=curRaster->height
	|| ((r->where ^ curRaster->where) & InverseRaster))
      {
	curWidth = r->width; curHeight = r->height;
	strcpy(InvertStr, r->where & InverseRaster? "Yes" : "No");
      }

    FreeMemRaster(curRaster);
    UpdatePad();
    printf("\033[4;1H");
    if (!(r->where&LinkedRaster))
        printf("(Not a linked raster)%20s", "");
    else
      { MemRaster *q; 
	for ((q = r->next, i = 0); q != r; q = q->next) i++;
	printf("Other pointers to this bitmap: %d.", i);
      }

    if (charValid) FontTab[curChar].raster = r;
    Show(curRaster = r);
    return(r);
  }

FollowMouse(f)
int (*f)();
  { int yOld = y, xOld = x, x0 = x, y0 = y, oldButtons = buttons;
    while ((buttons = GetGraphicsStatus(&vgtFile,&x,&y,0)) == oldButtons)
	if (y != yOld || x != xOld)
	  {
	    (*f)(x, y, 1);
	    xOld = x; yOld = y;
	  }
    if (buttons) (*f)(x0, y0, 1);
    return buttons;
  }

MemRaster *
AdjustEdges(edges)
  { short xLeft= -1, xRight=curRaster->width,
         yBot= -1, yTop=curRaster->height, changed;
    while (GetMouseStatus(&vgtFile,&x,&y,&buttons) >= 0)
	if (buttons==MiddleButton)
	  { changed=0;
	    if (edges&LeftEdge && x!=xLeft) {xLeft=x;changed=1;}
	    if (edges&RightEdge &&x!=xRight) {xRight=x;changed=1;}
	    if (edges&TopEdge && y!=yTop) {yTop = y;changed=1;}
	    if (edges&BottomEdge && y!=yBot) {yBot = y;changed=1;}
	    if (changed)
	      {
		EditSymbol(sdf,1);
		ChangeItem(sdf, OutlineItem, xLeft,xRight,yBot,yTop,
		 AllEdges,SDF_OUTLINE,0);
	        EndSymbol(sdf, 1, vgt);
	     }
	  }
	else if (buttons) return(curRaster);
	else return AdjustSize(xLeft + 1, curRaster->height - yTop,
	   yTop-yBot-1, xRight-xLeft-1);
  }

AdjustCharAttr()
  { int w = curRaster->width, xOld = x, yOld = y;
    register struct CharData *tabP;
    if (!charValid) return 0;
    tabP = &FontTab[curChar];
    if (y == tabP->bBox[Y] - tabP->origin[Y]
      && x >= -3 && x < -1)
      { int oldButtons = buttons;
	FollowMouse(ShowBaselineItem);
	if (buttons == 0)
	  { int change = y - yOld;
	    tabP->origin[Y] -= change;
	    tabP->width[Y] += change << 16;
	    CalculateDescentAndHeight();
	    goto done;
	  }
	else return -1;
      }
    if (x == tabP->origin[X]
     && y > curRaster->height && y <= curRaster->height + 2)
      {
	FollowMouse(ShowXstartItem);
	if (buttons == 0)
	  { int change = x - xOld;
	    tabP->width[X] -= change << 16;
	    tabP->origin[X] = x;
	    goto done;
	  }
	else return -1;
      }
    if (x == tabP->origin[X] + (tabP->width[X]>>16)
     && y >= -3 && y < -1)          
      {
	FollowMouse(ShowWidthItem);
	if (buttons == 0)
	  {
	    tabP->width[X] += (x - xOld) << 16;
	    goto done;
	  }
	else return -1;
      }
    if (y == tabP->bBox[Y] - tabP->origin[Y] - (tabP->width[Y]>>16)
     && x > tabP->bBox[X] && x <= tabP->bBox[X] + 2)          
      {
	FollowMouse(ShowHeightItem);
	if (buttons == 0)
	  { int change = y - yOld;
	    tabP->width[Y] -= change << 16;
	    CalculateDescentAndHeight();
	    goto done;
	  }
	else return -1;
      }

    return 0;
  done:
    DoRedraw();
    return 1;
  }
SetGXBase() /* just in case we try to read from the frame buffer */
  {
    MachineConfigurationReply mreply;    
    QueryKernel(0, MACHINE_CONFIG, &mreply);
    if (mreply.machine == MACH_SMI_SUN2)
	GXBase = Sun2GXDefaultBase;
    else	    
	GXBase = GXDefaultBase;
  }
