/*
 * A struct BitPtr points to a particular bit in a MemRaster.
 * It is used for scanning though the bits of a MemRaster
 */
 
#include <bitmaps.h>

struct BitPtr
  {
    short x, y;
    /*rest is "user-invisible" */
    MemRaster *r;
    u_short *ptr;	/* points to current word */
    u_short mask;	/* == 0xFFFF >> (col & 15) */
  };

/* values for 'color' parameter of SearchBit */
#define SearchWhite 0
#define SearchBlack 1
#define SearchEdge 0
#define SearchDown 2
#define SearchUp 4
