
#include <Venviron.h>
#include <Vio.h>
#include <Vauthenticate.h>
#include <fields.h>

extern SystemCode AddUser(), DeleteUser(), ModifyUser();
extern SystemCode Password(), MapUserName(), MapUID();

char promptstring[40];
char inputline[40];
char *emptyString = "(null)";
char *BLANK = "";
char *NONE = "NO PASSWORD";
AuthRec AR;

int ADD(), DELETE(), MODIFY(), FIND(), Edit();

#define RESET(rec) (rec)->name=(rec)->fullname=(rec)->home=(rec)->passwd=NULL
#define ClearScreen()putc('L' & 0x1f, stdout)

int QUIT(){ ClearScreen(); exit(0); }
int YES(){};
int NO(){};

Field Menu[] = 
  {
	{ 1, 1, -1, 0, NULL, "V-System authentication tool" },
	{ 5, 5, -1, 0, NULL, "Name  |" },
	{ 6, 5, -1, 0, NULL, "Fname |" },
	{ 7, 5, -1, 0, NULL, "Uid   |" },
	{ 8, 5, -1, 0, NULL, "Home  |" },
#define PROMPTSTRING 5
	{ 11, 1, -1, VAL promptstring, NULL, "%s" },
#define INPUTLINE PROMPTSTRING+1
	{ 11, 1, -1, VAL inputline, Edit, "%s" },

#define UID INPUTLINE+1
	{ 7, 13, -1, 0, NULL, "%s" }, /* UID and PASSWD aren't editable */
#define PASSWD UID+1
	{ 9, 5, -1, 0, NULL, "" },
#define FIELDSTART PASSWD+1
#define NAME PASSWD+1
	{ 5, 13, 255, 0, Edit, "%s" },
#define FNAME NAME+1
	{ 6, 13, 255, 0, Edit, "%S" },
#define HOME FNAME+1
	{ 8, 13, 255, 0, Edit, "%s" },
#define FIELDEND FIELDSTART+2
#define BUTTONSTART FIELDEND+1
	{ 3,  1, 10, 0, FIND, "[Find]" },
	{ 3,  8, 10, 0, ADD, "[Add]" },
	{ 3, 14, 10, 0, MODIFY, "[Modify]" },
	{ 3, 23, 10, 0, DELETE, "[Delete]" },
	{ 3, 32, 10, 0, QUIT, "[Exit]" },
#define BUTTONEND BUTTONSTART+4
#define CONFIRMSTART BUTTONEND+1
	{ 13, 1, -1, 0, NULL, "" },
	{ 13, 10, -1, 0, YES, "" },
	{ 13, 16, -1, 0, NO, "" },
#define CONFIRMEND CONFIRMSTART+2
	LASTFIELD
  };

GetLine( p )
char *p;
  {
    inputline[0] = 0;
    strcpy( promptstring, p );
    Menu[INPUTLINE].col = strlen(p) + 2;
    ClearScreen();
    DisplayFields(Menu, 999, stdout);
    EditStdFld( &Menu[INPUTLINE] );
  }

Error( code )
SystemCode code;
  {
    if (code == OK) promptstring[0] = 0;
    else strcpy(promptstring, ErrorString( code ));
  }

SystemCode Confirm()
  {
    Field *f;
    int i;

    for (f = &Menu[0]; f < &Menu[CONFIRMSTART]; f++) f->width = -1;
    while (1)
      {
	Menu[CONFIRMSTART].format = "Confirm:";
	Menu[CONFIRMSTART+1].width = 3;
	Menu[CONFIRMSTART+1].format = "[Yes]";
	Menu[CONFIRMSTART+2].width = 2;
	Menu[CONFIRMSTART+2].format = "[No]";
	ClearScreen();
	DisplayFields(Menu, 999, stdout);
	f = GetField(Menu, 999, 0, stdout);

	for (i = 0; i < 3; i++)
	  {
	    Menu[CONFIRMSTART+i].width = -1;
	    Menu[CONFIRMSTART+i].format = "";
	  }
	
	if (f)
	  {
	    if (f->proc == YES) return(OK);
	    if (f->proc == NO ) return(OK+1); /* Not OK! */
	  }
      }
  }

ADD(field)
Field *field;
  {
    SystemCode r;
    char password[20];

    GetLine("New password:");
    strcpy( password, inputline );
    GetLine("Retype password:");
    if (strcmp(password, inputline))
      {
	strcpy("Password mismatch", promptstring);
	return;
      }
    if (AR.passwd) free(AR.passwd);
    AR.passwd = (char *) malloc( strlen( password ) + 1);
    strcpy( AR.passwd, password );
    
    Error( r = AddUser(AR.name, AR.passwd, AR.fullname, AR.home) );
    if (r == OK)
      {
	MapUserName(AR.name, &AR); /* Get the new passwd */
	sprintf(promptstring, "%s added", AR.name);
	Menu[PASSWD].format = (AR.passwd && *AR.passwd) ? BLANK : NONE;
      }
  }

DELETE(field)
Field *field;
  {
    SystemCode r;

    sprintf(promptstring, "Confirm deleting %s", AR.name);
    if (Confirm() == OK)
      {
	Error( r = DeleteUser(AR.name) );
	if (r == OK)
	  {
	    sprintf(promptstring, "%s deleted", AR.name);
	    DestroyAuthRec( &AR );
	    RESET(&AR);
	    Menu[PASSWD].format = (AR.passwd && *AR.passwd) ? BLANK : NONE;
	  }
      }
    else sprintf(promptstring, "%s not deleted", AR.name);
  }

MODIFY(field)
Field *field;
  {
    SystemCode r;
    char password[20];
    
    password[0] = 0;
    if (User(0) != SUPER_USER)
      {
	GetLine("Old password:");
	if ((r = Password(AR.name, inputline)) != OK) { Error( r ); return; }
	strcpy( password, inputline );
      }
    GetLine("New password:");
    if ( strcmp(password, inputline) )
      {
	strcpy( password, inputline );
	GetLine("Retype password:");
	if (strcmp( password, inputline ))
	  {
	    strcpy(promptstring, "Password mismatch");
	    return;
	  }
      }
    if (AR.passwd) free(AR.passwd);
    AR.passwd = (char *) malloc(strlen(password) + 1);
    strcpy(AR.passwd, password);
    Error( r = ModifyUser(&AR) );
    if (r == OK)
      {
	MapUserName(AR.name, &AR); /* Get the new passwd */
	sprintf(promptstring, "%s modified", AR.name);
	Menu[PASSWD].format = (AR.passwd && *AR.passwd) ? BLANK : NONE;
      }
  }

FIND(field)
Field *field;
  {
    GetLine("Find user:");
    Error( MapUserName( inputline, &AR ) );
  }

int Edit( f )
Field *f;
  {
    char s[80], **save;

    if ( f == &Menu[NAME] ) save = &AR.name;
    else if ( f == &Menu[FNAME] ) save = &AR.fullname;
    else if ( f == &Menu[HOME] ) save = &AR.home;

    if (f->value == VAL emptyString) s[0] = 0;
    else
      {
	strcpy( s, (char *) f->value);
	free( (char *) f->value );
      }
    f->value = VAL s;
    ClearScreen();
    DisplayFields(Menu, 999, stdout);
    EditStdFld( f );
    *save = (char *) malloc(strlen(s) + 1);
    strcpy( *save, s );
  }

main()
  {
    Field *field;
    char uidstring[10];
    
    RESET(&AR);
    MapUID(User(0), &AR);
    inputline[0] = 0;
    while (1)
      {
	sprintf(uidstring, "%d", AR.uid);
	Menu[NAME].value = VAL AR.name;
	Menu[FNAME].value = VAL AR.fullname;
	Menu[UID].value = VAL uidstring;
	Menu[HOME].value = VAL AR.home;
	Menu[PASSWD].format = (AR.passwd && *AR.passwd) ? BLANK : NONE;

	for (field = &Menu[FIELDSTART]; field <= &Menu[FIELDEND]; field++)
	  {
	    if ( (field->value != NULL) && (*(char *)field->value) )
		field->width = strlen(field->value);
	    else
	      {
		field->value = VAL emptyString;
		field->width = 6;
	      }
	  }
	for (field = &Menu[BUTTONSTART]; field <= &Menu[BUTTONEND]; field++)
	    field->width = strlen(field->format);

	inputline[0] = 0;
	ClearScreen();
	DisplayFields(Menu, 999, stdout);
	field = GetField(Menu, 999, 0, stdout);
	if (field) (*(field->proc))(field);
      }
  }

