/*
 * "delcorr" - Deletes existing user correspondences (if any) for the
 * invoking user, or for any user if the invoker is the V super user.
 */

#include <Vauthenticate.h>
#include <Vio.h>
#include <Vsession.h>
#include <Vtermagent.h>

#define BUFFER_SIZE 100

static char Buffer[BUFFER_SIZE];

main(argc, argv)
    int argc;
    char *argv[];
  {
    UID user;
    AuthRec ar;
    SystemCode result;
    
    user = User(0);
    if (user == SUPER_USER)
      {
	printf("Delete user correspondences for (enter V user name)? ");
	gets(Buffer);
	if ((result = MapUserName(Buffer, &ar)) != OK)
	  {
	    printf("Couldn't map '%s': %s\n",
		   Buffer, ErrorString(result));
	    exit(1);
	  }
	user = ar.uid;
      }
    else
      {
	if ((result = MapUID(user, &ar)) != OK)
	  {
	    printf("Couldn't map user number %d: %s\n",
		   user, ErrorString(result));
	    exit(1);
	  }
	printf("Deleting user correspondences for V user %d (\"%s\").\n",
	       user, ar.name);
      }

    while (1)
      {
	ProcessId serverPid;

	/* Get remote host name: */
	  {
	    char *hostName;
	    ContextPair ctx;
	    SystemCode result;
   
	    strcpy(Buffer, "[storage/");
	    hostName = &Buffer[strlen(Buffer)];
	    printf("\nEnter remote host name (type <return> to exit): ");
	    gets(hostName);
	    if (Equal(hostName, ""))
		return;
	    printf("%s ... ", Buffer); Flush(stdout);
	    result = GetContextId(Buffer, &ctx);
	    printf("%s\n", ErrorString(result));
	    if (result != OK)
		continue;
	    serverPid = ctx.pid;
	  }
	
	/* Send the request: */
	  {
	    Message msg;
	    register UserCorrespondenceRequest *req =
		(UserCorrespondenceRequest *)msg;
	    register UserCorrespondenceReply *reply =
		(UserCorrespondenceReply *)msg;

	    req->requestcode = DELETE_USER_CORRESPONDENCE;
	    req->vUserNumber = user;
	    
	    Send(req, serverPid);
	    if (reply->replycode == OK)
		printf("User correspondence successfully deleted\n");
	    else
	      {
		PrintError(reply->replycode,
			   "Could not delete user correspondence");
		continue;
	      }
	  }
      }
  }
