/*
 * "addcorr" - Adds user correspondences for the invoking user, or for 
 * any user if the invoker is the V super user.
 */

#include <Vauthenticate.h>
#include <Vio.h>
#include <Vsession.h>
#include <Vtermagent.h>

#define BUFFER_SIZE 100

static char Buffer[BUFFER_SIZE];

main(argc, argv)
    int argc;
    char *argv[];
  {
    UID user;
    AuthRec ar;
    SystemCode result;
    
    user = User(0);
    if (user == SUPER_USER)
      {
	printf("Add user correspondences for (enter V user name)? ");
	gets(Buffer);
	if ((result = MapUserName(Buffer, &ar)) != OK)
	  {
	    printf("Couldn't map '%s': %s\n",
		   Buffer, ErrorString(result));
	    exit(1);
	  }
	user = ar.uid;
      }
    else
      {
	if ((result = MapUID(user, &ar)) != OK)
	  {
	    printf("Couldn't map user number %d: %s\n",
		   user, ErrorString(result));
	    exit(1);
	  }
	printf("Adding user correspondences for V user %d (\"%s\").\n",
	       user, ar.name);
      }

    while (1)
      {
	ProcessId serverPid;

	/* Get remote host name: */
	  {
	    char *hostName;
	    ContextPair ctx;
	    SystemCode result;
   
	    strcpy(Buffer, "[storage/");
	    hostName = &Buffer[strlen(Buffer)];
	    printf("\nEnter remote host name (type <return> to exit): ");
	    gets(hostName);
	    if (Equal(hostName, ""))
		return;
	    printf("%s ... ", Buffer); Flush(stdout);
	    result = GetContextId(Buffer, &ctx);
	    printf("%s\n", ErrorString(result));
	    if (result != OK)
		continue;
	    serverPid = ctx.pid;
	  }
	
	/* Get user name: */
	printf("Enter user name on remote host: ");
	gets(Buffer);
	
	/* Get password: */
	  {
	    char *password;
	    int oldmode;
	    
	    printf("Password: ");
	    Flush(stdout);
	    oldmode = QueryPad(stdin);
	    ModifyPad(stdin, oldmode & (~Echo));
	    password = &Buffer[strlen(Buffer) + 1]; /* User name must remain
	    					       0-terminated. */
	    gets(password);
	    ModifyPad(stdin, oldmode);
	    Flush(stdout);
	  }

	/* Send the request: */
	  {
	    Message msg;
	    register UserCorrespondenceRequest *req =
		(UserCorrespondenceRequest *)msg;
	    register UserCorrespondenceReply *reply =
		(UserCorrespondenceReply *)msg;

	    req->requestcode = ADD_USER_CORRESPONDENCE;
	    req->vUserNumber = user;
	    req->segmentptr = Buffer;
	    Buffer[BUFFER_SIZE - 1] = '\0'; /* just in case */
	    req->segmentlen = BUFFER_SIZE;
	    
	    Send(req, serverPid);
	    if (reply->replycode == OK)
		printf("User correspondence entered successfully\n");
	    else
	      {
		PrintError(reply->replycode,
			   "Could not enter new user correspondence");
		continue;
	      }
	  }
      }
  }
