/*
 * V Kernel - Copyright (c) 1985 by Stanford University
 *
 * Kernel Framebuffer support routines
 *
 * The "qvss" provides access to the framebuffer and to the framebuffer's
 * machine registers.  Opening this device causes the framebuffer to be
 * mapped into your address space, and reading from or writing to this
 * device causes a read/write to the machine register that controls it.
 *
 * $Revision: 1.8.1.6 $
 * $Locker:  $
 * $State: Exp $
 */

#ifndef QVSS_H
#define QVSS_H

#ifndef QBUSADDRESSES_H
# include "qbusaddresses.h"
#endif

/*
 * Qvss Location (in Q-bus I/O and Memory space), size, etc.
 *   PhysQvss and QVSSMEMSWITCHES assume factory settings for I/O and
 *   memory addresses respectively.
 */
#define	QVSS_REGS_QBUS	017777200	/* octal */
#define	QVSS_REGS_P	qbus_device_to_p(QVSS_REGS_QBUS)
#define	QVSS_REGS_V	qbus_device_to_v(QVSS_REGS_QBUS)
#define NUMQVSSREGS	32
#define NUMUSERQVSSREGS	6
#define QVSS_MEM_SIZE	0x40000	/* in bytes */
#define QVSSMEMSWITCHES 0xF
#define	QVSS_MEM_P	qbus_memory_to_p(QVSS_MEM_SIZE*QVSSMEMSWITCHES)

typedef struct {
    unsigned short  regs[NUMQVSSREGS];
} qvss_reg_t;

/* what follows are some definitions for the various registers in the
 * Qvss device.  I suggest you read a manual for a description
 * of the various fields.  It is incredible.
 */

/* the base csr */
#define QV_CSR		0
#define		QV_BIGSCREEN	0x0001
#define		QV_ENABLEVID	0x0004
#define		QV_CURSORFUNC	0x000f
#define		QV_VIDLOOP	0x0010
#define		QV_LOOPTEST	0x0020
#define		QV_INTENABLE	0x0040
#define		QV_ONCURS	0x0080
#define		QV_MOUSEA	0x0100
#define		QV_MOUSEB	0x0200
#define		QV_MOUSEC	0x0400
#define		QV_MEM0		0x0800
#define		QV_MEM1		0x1000
#define		QV_MEM2		0x2000
#define		QV_MEM3		0x4000

/* the framebuffer stuff */
#define	QV_CURSX	1
#define		QV_CURSPOSMASK	0x03ff
#define	QV_MOUSE	2
#define		QV_MOUSEXMASK	0x00ff
#define		QV_MOUSEYMASK	0xff00
#define	QV_CRTCA	4
#define		QV_CRTREG	0x001f
#define			QV_HORTOT	0
#define			QV_HORDIS	1
#define			QV_HSYNCPOS	2
#define			QV_SYNCWIDTH	3
#define			QV_VERTTOT	4
#define			QV_VERTTOTADJ	5
#define			QV_VERTDISP	6
#define			QV_VSYNCPOS	7
#define			QV_CRTMODE	8
#define			QV_SCANLINE	9
#define			QV_CSCANSTART	10
#define			QV_CSCANEND	11
#define			QV_STARTADDRHI	12
#define			QV_STARTADDRLO	13
#define			QV_CURSADDRHI	14
#define			QV_CURSADDRLO	15
#define			QV_LPENPOSHI	16
#define			QV_LPENPOSLO	17
#define		QV_VERTBLANK	0x0020
#define		QV_LPENREGFULL	0x0040
#define		QV_UPDATESTROBE	0x0080
#define	QV_CRTCD	5

/* the interrupt controller */
#define	QV_IUARTMASK	0x01	/* the interrupt bit field masks */
#define	QV_IVSYNCMASK	0x02
#define	QV_IMOUSEMASK	0x04
#define	QV_ICSTARTMASK	0x08
#define	QV_IMOUSEAMASK	0x10
#define	QV_IMOUSEBMASK	0x20
#define	QV_IMOUSECMASK	0x40

#define	QV_IUARTNUM	0	/* the interrupt bit field numbers */
#define	QV_IVSYNCNUM	1
#define	QV_IMOUSENUM	2
#define	QV_ICSTARTNUM	3
#define	QV_IMOUSEANUM	4
#define	QV_IMOUSEBNUM	5
#define	QV_IMOUSECNUM	6

#define	QV_PRIORITIES	0x01
#define	QV_IMVECTORS	0x02
#define	QV_IMINTPOLL	0x04
#define	QV_IMREG	0x60
#define	QV_IMINTENABLE	0x80
#define	QV_ICDR		6
#define	QV_ICSR		7

/* The UARTs */
#define	QV_UISM		21
#define	QV_UMODE	16
#define	QV_USCSR	17
#define	QV_UCMD		18
#define	QV_UBUFF	19
#define	UARTBOFFS	8
#define	UARTAOFFS	0

/* Qvss keyboard hangs off UARTA.  See qvsskeytab.h */

unsigned char FindQvss _TAKES(( int (**)() ));
void BuildSysMap_Qvss _TAKES(());
void QvssPowerup _TAKES(()); 
void QvssMousePowerup _TAKES(()); 
void QvssKeyboardInit _TAKES(());

/* Assembly Language Exports */
_BEGIN_EXTERN_C
void IntQvssUart _TAKES(()); 
void IntQvssMousePoll _TAKES(());
void Asm_IntQvssUart _TAKES(()); 
Asm_IntQvssMousePoll _TAKES(());
_END_EXTERN_C

/* lk201.c */
extern void LK201_GotKey   _TAKES((int key));
extern void LK201_Init     _TAKES((void (*putchar_proc)(int)));
#endif QVSS_H
