/*
 * The memory-mapping routines provide a window into the Q-Bus I/O space.
 *   _p		is the starting physical address that a processor should use,
 *   _v		is the corresponding virtual address ("_p" is only used early
 *		    in the kernel bootstrap),
 *   _size	is the size (in bytes) of the window,
 *   _base	is the Q-bus I/O address to which "_p" and "_v" are mapped.
 *
 * $Revision: 1.4.1.1 $
 * $Locker:  $
 * $State: Exp $
 */

#ifndef QBUSADDRESSES_H
#define QBUSADDRESSES_H

extern		char *qbus_devices_p;
extern		char *qbus_devices_v;
extern		char *qbus_devices_base;
extern unsigned long  qbus_devices_size;

#define	qbus_device_addr_valid(qbus_device_addr)		\
	( (char *)(qbus_device_addr) >= qbus_devices_base &&	\
	  (char *)(qbus_device_addr) <= qbus_devices_base + qbus_devices_size )
#define	qbus_device_to_p(qbus_device_addr)			\
	( (char *)(qbus_device_addr) + (qbus_devices_p - qbus_devices_base) )
#define	qbus_device_to_v(qbus_device_addr)			\
	( (char *)(qbus_device_addr) + (qbus_devices_v - qbus_devices_base) )

/*
 * Similarly, there's a window onto Q-Bus memory space.  The MicroVAX I
 *   actually uses Q-Bus memory as its main processor memory; other processors
 *   tend to have separate main memories and just use this for poking at
 *   devices such as the QVSS (which uses a 256K slice of Q-Bus memory space)
 */

extern		char *qbus_memory_p;
		/* No qbus_memory_v, since the kernel doesn't ever map it; */
		/*    just particular slices for devices such as the QVSS. */
extern		char *qbus_memory_base;	/* Most likely 0 */
extern	unsigned long qbus_memory_size;

#define	qbus_memory_addr_valid(qbus_memory_addr)		\
	( (char *)(qbus_memory_addr) >= qbus_memory_base &&	\
	  (char *)(qbus_memory_addr) <= qbus_memory_base + qbus_memory_size )
#define	qbus_memory_to_p(qbus_memory_addr)			\
	( (char *)(qbus_memory_addr) + (qbus_memory_p - qbus_memory_base) )

/*
 * So much for processors accessing Q-Bus I/O and memory.  Q-Bus DMA devices
 *   may also generate Q-Bus memory addresses, and generally we want these to
 *   be mapped to the processor's main memory.  On the MicroVAX I, the mapping
 *   is the identity function; the MicroVAX II and Firefly provide 8192
 *   registers which can map each page of Q-Bus memory space to anywhere in
 *   main memory.
 */
/* ------- declarations for this are in uvaxmemory.h, which I believe is the
	   right place. */
#endif QBUSADDRESSES_H
