/*
 * Distributed V Kernel - Copyright (c) 1981 by David Cheriton.
 * (Transliterated from Zed and Verex Kernel)
 * Copyright (c) 1982 Stanford University.
 *
 * Processor Header File for VAX
 * Definition of per-processor record and related macros.
 *
 * $Revision: 1.8.1.21 $
 * $Locker:  $
 * $State: Exp $
 */

#ifndef PROCESSOR_H
#define PROCESSOR_H

#ifndef ASMDEFS_H
# include "asmdefs.h"
#endif
#ifndef VEXCEPTIONS_H
# include <Vexceptionprotocol.h>
#endif
#ifndef VNETWORK_H
# include <Vnetwork.h>
#endif
#ifndef VQUERYKERNEL_H
# include <Vquerykernel.h>
#endif
#ifndef VPROCESSCOMMON_H
_BEGIN_EXTERN_C
#include <Vprocesscommon.h> }
_END_EXTERN_C
#endif VPROCESSCOMMON_H


#define MD_PAGEBITS	9			/* LOG2 (512) */
#define MD_PAGESIZE	(1<<MD_PAGEBITS)	/* in bytes */
#define	MD_PAGEMASK	(MD_PAGESIZE-1)
/*
 * VPAGEBITS=log2(VPAGESIZE).  VPAGESIZE must be >= MD_PAGESIZE.
 */
/*
 * Definitions for the "V page-size" (as opposed to the machine's actual page-
 *   size) which is used by mi parts of the memory manager.
 */
#define VPAGEBITS	10
#define	VPAGESIZE	(1<<VPAGEBITS)	/* import from memory.h */
#define VPAGEMASK	(VPAGESIZE-1)

#define	PAGESIZERATIO	(VPAGESIZE/MD_PAGESIZE)

#define	MD_PageOffs(addr)	((unsigned)(addr) & (MD_PAGESIZE-1))

#define MD_DownToPage(addr) \
	( (unsigned)(addr) & ~MD_PAGEMASK )

#define MD_PageNumber(addr) \
	( (unsigned)(addr) >> MD_PAGEBITS )

/* round addr up to the nearest page boundary */
#define	MD_UpToPage(addr) \
	( ( (unsigned)(addr)+MD_PAGESIZE-1 ) & ~MD_PAGEMASK )

/* return the page number of the next unused page after addr */
#define	MD_NumPages(addr) \
	MD_PageNumber(MD_UpToPage(addr))

#define STACK_SIZE	0x2000		/* Size of kernel's stacks */

#define TEAM_START	0
#define TEAM_LIMIT	0x1000000	/* Max team size; 16Mb means 1K   */
					/*   bytes per team in the system */
					/*   page table.  Could be larger.*/

#define PHYS_MEM_BASE	0L		/* The physical address of */
					/* VPageNumber 0 */

/* VAX Process Control Block */
typedef struct _VPCB
  {
	/* Machine dependent fields */
	Unspec		KernelSP;	/* Kernel Stack pointer */	
	Unspec		ExecSP;		/* Executive mode stack pointer */
	Unspec		SuperSP;	/* Supervisor mode stack pointer */
	Unspec  	UserSP;		/* User mode stack pointer */
	Unspec		regs[14];	/* r0 - r13 general registers */
	/* register 14 the stack pointer is stored in one of the SP's */
	Unspec		PC;		/* program counter r15 */
	Unspec		PSL;		/* processor status long word */
	unsigned	ProgBaseReg;	/* program region base register */
	unsigned	ProgLenReg:22;	/* program region length register */
	unsigned 	MBZfield1:2;	/* must be zero field */
	unsigned	AstLevel:3;	/* Asynchronous system trap level */
	unsigned	MBZfield2:5;	/* must be zero field */
	unsigned	CtrlBaseReg;	/* control region base register */
	unsigned 	CtrlLenReg:22;	/* control region length register */
	unsigned	MBZfield3:10;	/* mustbe zero field */
	/* High order bit of this last register is actually the performance
	   monitor enable bit */
  } VAXProcessControlBlock;

/* Processor State as stored inside the kernel */
typedef struct _KPS
  {
    ProcessContext pcontext;
  } KProcessorState;

/*
 * Machine dependent part of the per-processor record.
 * Interrupt Stack should come first
 */

typedef struct
  {
    char 	*istack;	/* Interrupt Stack */
    char 	*kstack;	/* Kernel Stack */
    VAXProcessControlBlock pcb;		/* VAX process control block */
    unsigned	ticks;
    unsigned 	pnumber;
    ExceptionStackFrame frame;
    unsigned    exceptionType;
    struct _PD  *addressableProcess;
  }
    Md_processor_rec;

/* 
 * Get the address  of the per-processor record and store it in prp.
 * prp (Processor Record Pointer) must be a valid destination in a VAX asm.
 */
#define AsmGetProcessorRecord(prp)					\
;asm("	mfpr $esp, prp");

#define GetProcessorNo(PRecp)						\
  ( ( (ProcessorRec *) (PRecp) )->md.pnumber )

extern struct _PRec ProcessorArray[];

#define IsPrimaryProcessor(PRecp)					\
  ( (PRecp) == ProcessorArray )

#define PRIMARY_PROCESSOR	0

typedef struct
  {
    unsigned	p0base;	/* System virtual address of P0 page table */
    unsigned	p0len;	/* Number of valid entries in "        "   */
  } Team_space;

/*
 * disable is supposed to disable ALL interrupts, enable enables only Timer
 * interrupts, if that is possible.  In all cases, Ethernet/device
 * interrupts should be disabled.
 *
 * Unfortunately, the VAX still misses clock ticks this way, so we are
 * going to make disable enable clock ints.
 */
#ifndef FIREFLY
#define disable	;asm("	mtpr	$0x15, $ipl")
#define enable	;asm("	mtpr	$0x15, $ipl")
#endif FIREFLY

#ifdef FIREFLY
#define disable
#define enable 
#endif FIREFLY


/* 
 * These macros are needed for synchronizing access to variables modified
 * by the timer interrupt handler.
 */

#define DisableAllInterrupts 	;asm("	mtpr	$0x16, $ipl")
#define EnableTimerInterrupts	;asm("	mtpr	$0x15, $ipl")

#ifdef FIREFLY
/* 
 * The following macros are for enabling and disabling interrupts on the
 * Firefly. On processor 0, Kdisable sets the IPL to 0x15. On the other 
 * processors, Kdisable is a no-op. We do this because the only interrupts
 * which secondary processors receive are interprocessor interrupts, which we
 * do not wish to disable on secondary processors. 
 */

/* Disable interrupts on processor 0 */
#define	PrimaryDisable							\
  ;asm("	   mtpr	$0x15,$ipl")

/* Enable interrupts on processor 0 */
#define	PrimaryEnable							\
  ;asm("	   mtpr	$0x15,$ipl")

/* Disable interrupts on VAX machines including the Firefly  */
#define Kdisable						\
  AsmGetProcessorRecord(-(sp));						\
  asm("	cmpl	(sp)+,$_ProcessorArray");  /* is this processor 0 ? */  \
  asm("	bneq	1f");						\
  asm("	mtpr	$0x15,$ipl");					\
  ;asm("	1:	")

/* Enable interrupts on VAX machines including the Firefly  */
#define Kenable							\
  AsmGetProcessorRecord(-(sp));						\
  asm("	cmpl	(sp)+,$_ProcessorArray");  /* is this processor 0 ? */  \
  asm(" bneq	1f");						\
  asm("	mtpr	$0x15,$ipl");					\
  ;asm("	1:	")
#endif FIREFLY

/* 
 * The following macros and declarations are for locking on the Firefly.
 */

extern int KernelLock;
extern struct _PRec *KLockHolder;
extern int HoldKLock;

#ifndef FIREFLY
#define Kdisable						
#define Kenable							
#define	PrimaryDisable							
#define	PrimaryEnable							
#define KLock()				
#define ExceptionKLock()
#define KLockNowait(status)					
#define KUnlock() 							

#else

/* This macro attempts to acquire the lock and blocks until it gets it */

#define KLock()					\
  asm("	brb	5f");						\
  asm("	1:	");						\
  AsmGetProcessorRecord(-(sp));						\
  asm("	cmpl	(sp)+,$_ProcessorArray");			\
  asm("	beql	3f");						\
  asm("	2:	");						\
  asm("	tstw	_KernelLock");					\
  asm("	bneq	2b");						\
  asm(" brb	5f");						\
  asm("	3:	");						\
  asm("	cmpl	_IPRBuffer,$0");	/* dest */		\
  asm("	bneq	4f");						\
  asm("	movq	r4, -(sp)");		/* Save regs that C destroys */	\
  asm("	movq	r2, -(sp)");						\
  asm("	movq	r0, -(sp)");						\
  asm("	calls	$0,_HandleIPR");				\
  asm("	movq	(sp)+, r0");		/* Restore registers */		\
  asm("	movq	(sp)+, r2");						\
  asm("	movq	(sp)+, r4");						\
  asm("	4:	");						\
  asm("	tstw	_KernelLock");					\
  asm("	bneq	3b");						\
  asm(" 5:	");						\
  asm(" bbssi	$0,_KernelLock,1b");				\
  AsmGetProcessorRecord(_KLockHolder);	

/* 
 * This macro attempts to acquire the lock. If the lock is successfully
 * acquired, the value 1 is returned, otherwise 0 is returned.
 */
#define KLockNowait(status)					\
 do									\
    {									\
      ;Kdisable;							\
      asm(" 	bbssi	$0,_KernelLock,1f");				\
      AsmGetProcessorRecord(_KLockHolder);				\
      status = 1;							\
      ;asm("	brb	2f");						\
      asm("	1:	");						\
      status = 0;							\
      asm(" 2:	"); 							\
    }									\
  while (0); 

/* This macro releases the lock */
#define KUnlock() 							\
  asm("	bbcci	$0,_KernelLock,0f");					\
  asm("	0:	");							\
  asm("	clrl	_KLockHolder");

#endif FIREFLY

#define Lockq(queue)

#define Unlockq(queue)					\

#ifdef FIREFLY
/* Interprocessor Request Stuff on Firefly */

typedef struct
  {
    unsigned dest;
    unsigned sequenceNo;
    unsigned type;
    struct _PD *addressableProcess;
    unsigned device_function;
    Unspec params[5]; 
  }
    IPRBufferType;

extern IPRBufferType IPRBuffer;

extern void SendIPR();

#define SendDeviceServiceRequestToPrimary(iprb,function)		\
  {									\
    iprb->type = DEVICE_SERVICE;					       \
    iprb->device_function = function;				\
    SendIPR(PRIMARY_PROCESSOR);				 		\
  }
/* Codes for type field in interprocessor request buffer (IPRBuffer.type) */

#define NO_IPR			0x0
#define DEVICE_SERVICE		0x1
#define MEM_INVALIDATE		0x3
#define RESCHEDULE		0x4

/*
 * Codes used to designate a function to be called in a DEVICE_SERVICE
 * interprocessor request to the primary processor on Firefly.
 */

#define NULL_FUNCTION			0x0000
#define	K_GETCHAR			0x0100
#define	K_PUTCHAR			0x0101
#define CONSOLE_WRITE			0x0200
#define	RESET_MDC			0x0300
#define	MDC_READ			0x0301
#define	MDC_WRITE			0x0302
#define ENET_RESET			0x0400
#define	NETWORK_WRITE_DEQNA		0x0401
#define KABORT_DEQNA			0x0402

/* Null processor number. */

#define NULL_PROCESSOR		0xFFFF

/* Information about a kernel exception */
typedef struct
  {
    unsigned errcode;
    char *errstring;
    unsigned haltcode;
    Unspec oldisp;
  }
    KErrorInfoType;

extern KErrorInfoType KErrorInfo[];
extern BooleanInt Multiprocessor;
extern unsigned NProcessors;

/* Error codes for external and internal halts on the VAX */
/* This should not be here */

#define	EXT_HALT		0x2
#define	POWERUP			0x3
#define	ISP_ERR			0x4
#define	DBL_ERR			0x5
#define	HLT_INST		0x6
#define	SCB_ERR3		0x7
#define	SCB_ERR2		0x8
#define	CHM_FR_ISTK		0xA
#define	MCHK_AV			0x10
#define	KSP_AV			0x11

/* 
 * A macro to force a reschedule on the Firefly.
 * This is inline to avoid procedure call overhead on the VAX.
 */

#define Reschedule(PRecp)						\
  {									\
    IPRBuffer.type = RESCHEDULE;					\
    SendIPR( GetProcessorNo( (ProcessorRec *) PRecp ) );		\
  }
  
/*
 * A kludge to avoid a procedure call in Addready. We need to access $esp
 * and cannot access automatic variables in an adequate way from assembly 
 * language.
 */

extern struct _SQueue *GlobalReadyqKludge;
#define GetReadyq(rq)							\
  {									\
    AsmGetProcessorRecord(_GlobalReadyqKludge);				\
    rq = GlobalReadyqKludge;						\
  }
#endif FIREFLY

#ifdef FIREFLY
 
extern short KernelMutex();
extern KernelPutChar();

#else !FIREFLY

extern short KernelInterrupted;
#define KernelMutex()							\
  KernelInterrupted  

#define KernelPutChar(character)					\
  K_putchar(character)

#endif FIREFLY

#define SaveProcessContext()						 \
do									 \
  {									 \
    asm("	movl	r0,-(sp)");					 \
                       							 \
    asm("       mfpr    $esp,r0");    /* ptr to per-processor record */  \
    asm("       movl    _PR_ACTIVE(r0),r0");    /* r0 = active */	 \
									 \
    asm("       movl    4(sp), _PC(r0)");	/* Save PC */		 \
    asm("       movl    8(sp), _STATUS(r0)");	/* Save status */	 \
    asm("	mfpr	$usp, _USER_STACK_PTR(r0)");			 \
    asm("	mfpr	$ssp, _PCONTEXT + _SSP(r0)");			 \
									 \
    asm("	moval	_PCONTEXT(r0),r0");				 \
									 \
    asm("	movl	(sp)+,(r0)+");					 \
    asm("	movl	r1,(r0)+");					 \
    asm("	movq	r2,(r0)+");					 \
									 \
    asm("	movq	r4,(r0)+");					 \
    asm("	movq	r6,(r0)+");					 \
    asm("	movq	r8,(r0)+");					 \
    asm("	movq	r10,(r0)+");					 \
    asm("	movq	ap,(r0)+");					 \
  } while (0);


#ifdef FIREFLY
extern struct _PD *GetAddressableProcess();
extern void SetAddressableProcess();
#else
/* Macros for AddressableProcess stuff */
extern struct _PD * AddressableProcess;
extern unsigned	AddressableTemp;
#define	GetAddressableProcess() AddressableProcess

#define	SetAddressableProcess(newprocess) \
{									\
    AddressableTemp = (AddressableProcess = (newprocess))->team->team_space.p0base;	\
    asm("	mtpr	_AddressableTemp, $p0br");			\
    AddressableTemp = (newprocess)->team->team_space.p0len;		\
    asm("	mtpr	_AddressableTemp, $p0lr");			\
    asm("	mtpr	$0, $tbia");					\
}
#endif FIREFLY
 
/* To save interrupt mask in Add_ready */
#define Interrupt_mask		extern short intmask; register short
#define Mask_interrupts()	intmask; disable
#define Restore_interrupt_mask(mask) intmask = mask


#define ReturnPid(pd,value) pd->trap_params[0] = (unsigned) value
#define ReturnSegmentSize(pd,value) pd->trap_params[1] = (unsigned) value

#define SenderPid(pd) pd->trap_params[0] 
#define SentSegmentSize(pd) pd->trap_params[1]

/* Message copying macro */
#define Copy_msg( dest, src ) \
	*((MsgStruct *)(dest)) = *((MsgStruct *)(src))

/* User pointers must be outside kernel space and less than TEAM_LIMIT */
#define BadUserPtr(ptr) \
	( ((unsigned)(ptr)) >= ((unsigned)(TEAM_LIMIT)) )

/* Check whether the specified segment lies entirely within the
 *  specified process's team space
 */
#define SegOutsideTeamSpace(pd, ptr, len) \
( (len) != 0 &&  \
  ( (unsigned)(ptr) + (unsigned)(len) > (pd)->team->team_size || \
    (unsigned)(ptr) + (unsigned)(len) < (unsigned)(ptr) ) )

void AllocatePds _TAKES(());
void Idle _TAKES(());
void Init_root_team _TAKES(());
struct _PD *Init_active _TAKES(());
	/* vax/console.c */
void CreateStdIo _TAKES((struct _PD *));
	/* vax/deqna.c */
extern NetAddress EnetHostNumber;
	/* uvaxtimer.c */
unsigned long GenerateRandomNumber _TAKES(());
	/* vax/debugger.c */
void use_debugger _TAKES(());
void Init_debugger _TAKES(());
	/* vax/machine.c */
void Powerup _TAKES(());

/* processor.c */

ResponseCode CopyInRegisters _TAKES((struct _PD *, Processor_state *, int));
void CopyOutRegisters _TAKES((Processor_state *, struct _PD *));
extern MachineConfigurationReply MachineConfig;
extern PeripheralConfigurationReply PeripheralConfig;
extern KernelConfigurationReply KernelConfig;

void FindConfiguration _TAKES((void));
void CalcNum_PDs_and_TDs _TAKES(());
void FindMachineType _TAKES(());
int KernelGetChar _TAKES(());
void BuildSysMap_TDs _TAKES(());

/* exception.c */
void InitException _TAKES(());
void LockSCB _TAKES(());

/* This shouldn't be here */
/* mdcinput.c */
void MdcInputInit  _TAKES(());
extern	char	*commandMemory_virt_addr; /* Only used by mdcinput.c */

/* deqna.c */
void KabortDeqna _TAKES(( struct _PD *, ExceptionRequest *, char *));

/* trap.c */
_BEGIN_EXTERN_C
void Asm_Invoke_trap();
_END_EXTERN_C
#endif PROCESSOR_H
