/* Fake file. only purpose is to determine the offsets of fields within
 * process descriptor ,team descriptor and processor record for assembly 
 * routines.
 *
 * $Revision: 1.24.1.11 $
 * $Locker: ews $
 * $State: Exp $
 */
#include "process.h"
#include "processor.h"
#include <Vprocesscommon.h>
#include <Vexceptioncommon.h>

#define OutputAsm(name, pdfield)\
  printf("    asm(\"	.set	%s, 0x%x\");\n", name, (unsigned long)(pdfield))
/*
 * This translates a macro into a define; name is prepended with _
 */
#define OutputDef(name)\
  printf("    asm(\"	.set	_%s, 0x%x\");\n", "name", name)

int main()
  /* Write to standard output the header field for various PD offsets.
   * and such like.
   */
  {
#define	pd	((Process *)0)
#define	td	((Team    *)0)


#define	pr	((ProcessorRec  *)0)
    register Processor_state * procState = 0;


printf("#ifndef ASMDEFINES_H\n#define ASMDEFINES_H\n\n");
    OutputAsm("_LINK", &pd->link);
    OutputAsm("_LOCALPID", &pd->localPid);
	OutputDef(INVALID_PROCESS);
    OutputAsm("_PD_FLAGS", &pd->pdFlags);
	OutputDef(MSG_FLAG);
    OutputAsm("_STATE", &pd->state);
	OutputDef(READY);
    OutputAsm("_PRIORITY", &pd->priority);
    OutputAsm("_TEAM", &pd->team);
    OutputAsm("_NUM_TRANS", &pd->numTrans);
    OutputAsm("_DATA_SEG_PRO", &pd->dstSegment.pro);
    OutputAsm("_DATA_SEG_PTR", &pd->dstSegment.ptr);
    OutputAsm("_DATA_SEG_SIZE", &pd->dstSegment.size);
    /******* New versions of the names. Remove above two. DRC */
    OutputAsm("_DST_SEG_PTR", &pd->dstSegment.ptr);
    OutputAsm("_DST_SEG_SIZE", &pd->dstSegment.size);
    OutputAsm("_QUEUE_PTR", &pd->queuePtr);
    OutputAsm("_FINISHUP", &pd->finish_up);
    OutputAsm("_SEGMENT_PTR", &pd->srcSegment.ptr);
    OutputAsm("_SEGMENT_SIZE", &pd->srcSegment.size);
    /******* New versions of the names. Remove above two. DRC */
    OutputAsm("_SRC_SEG_PTR", &pd->srcSegment.ptr);
    OutputAsm("_SRC_SEG_SIZE", &pd->srcSegment.size);
    OutputAsm("_PID", &pd->pid);
    OutputAsm("_BLOCKED_ON", &pd->blocked_on);
    OutputAsm("_FORWARDER", &pd->forwarder);
    OutputAsm("_USER_NUMBER", &pd->userNumber);
    OutputAsm("_TRANSACTID", &pd->transactId );
    OutputAsm("_PACKET_DELIVERY", &pd->packetDelivery );
    OutputAsm("_MSG_DELIVERY", &pd->msgDelivery );
    OutputAsm("_CLIENT_PID", &pd->clientPid );
    OutputAsm("_SERVER_PID", &pd->serverPid );
    OutputAsm("_MSG", &pd->msg);
    OutputAsm("_REQUESTCODE", &pd->requestCode);
	OutputDef(OK);
    OutputAsm("_PD_READYQ", &pd->readyq);
    OutputAsm("_TIMEOUT_FUNC", &pd->timeout_func);
    OutputAsm("_TIMEOUT_COUNT", &pd->timeout_count);
    OutputAsm("_ALIEN_TRANSACTID", &(pd->alienTransactId));
    OutputAsm("_TRAP_PARAMS", &(pd->trap_params[0]));
    OutputAsm("_TRAP_PARAM2", &(pd->trap_params[2]));
    OutputAsm("_TRAP_PARAM3", &(pd->trap_params[3]));
    OutputAsm("_VM", &pd->vm);
    OutputAsm("_USER_STACK_PTR", &pd->userStackPtr);
    OutputAsm("_PC", &pd->PC);
    OutputAsm("_STATUS", &pd->status);
    OutputAsm("_PER_PROCESS", &pd->perProcess);

    OutputAsm("_PROCESSOR_STATE_LENGTH", sizeof *procState);

    OutputAsm("_MAX_TIMEOUT", &pd->maxTimeout);
    OutputAsm("_EMULATOR_SEGMENT", &pd->emulatorSegment);
    OutputAsm("_EMULATOR_DATA", &pd->emulatorData);
    OutputAsm("_PCONTEXT", &pd->pcontext);
        OutputAsm("_SSP", &((ProcessContext *)0)->supervisorStackPtr);

    OutputAsm("_TD_NEXT",		&td->next);
    OutputAsm("_TD_PREV",		&td->prev);
    OutputAsm("_TD_TEAM_ROOT",		&td->team_root);
    OutputAsm("_TD_OWNER",		&td->owner);
    OutputAsm("_TD_TEAM_PRIORITY",	&td->team_priority);
    OutputAsm("_TD_MIN_PRIORITY",	&td->min_priority);

    OutputAsm("_TD_ID",			&td->id);

    OutputAsm("_TD_P0LEN",		&td->team_space.p0len);
    OutputAsm("_TD_P0BASE",		&td->team_space.p0base);
    OutputAsm("_TD_BRS",		&td->brs);
    OutputAsm("_TD_DCBRS",		&td->dcbrs);
    OutputAsm("_TD_TEAM_SIZE",		&td->team_size);

    OutputAsm("_PR_READYQ",		&pr->readyq);
    OutputAsm("_PR_ACTIVE",	        &pr->active);
    OutputAsm("_PR_IDLE_PROCESS",	&pr->idle_process);
    OutputAsm("_PR_ISTACK",		&pr->md.istack);
    OutputAsm("_PR_KSTACK",		&pr->md.kstack);

    OutputAsm("_PR_FRAME",		&pr->md.frame);
    OutputAsm("_PR_EXCEPTION_TYPE",     &pr->md.exceptionType);
    OutputDef(PSL_CURMOD);
    OutputDef(PSL_CUREXEC);
    OutputDef(PSL_CURSUPER);
    OutputDef(PSL_IPL);
    OutputDef(VecCHMK);
printf("\n#endif ASMDEFINES_H\n");
    /* Provide this status for build, else it gets set to a garbage value */
    return 0;	
  }
