/*
 * Reference: Firefly Programmer's Manual.
 */
#ifndef FIREFLY_H
#define FIREFLY_H

/* This should not be here */
#define PROCESSOR_CONFIG_ADDR		0x20040004 
#define CONFIG_UVAX2			0x01010000
#define CONFIG_CCF			0x017F0000

/* On the CVAX Firefly the timeronly interrupts every 20 ms */
#define CCF_CLICKS_PER_TICK		2

extern char *ipcrs_v; /* Virtual addr of interprocessor communication space */

/*
 * PC at which a Firefly secondary processor begins execution when booted.
 * This is a physical address. Note also that if there is a halt on a secondary
 * processor, there is a transfer of control to this address.
 * Reference: Firefly Programmer's Manual, Section 6.
 */
#define FF_SECONDARY_INIT_PC			0x40000

/* Firefly interprocessor communication space: address, bits and masks */
#define FF_INTERPROCESSOR_COMM_REG_SPACE_PHYS_ADDR		0xfff000
#define FF_MODE_POS		3
#define FF_SC_POS		2

#define FF_INTERRUPT	(0 << FF_MODE_POS)
#define FF_RESET	(1 << FF_MODE_POS)
#define FF_CACHE_MISS	(2 << FF_MODE_POS)

#define FF_CACHE_INIT	(2 << FF_MODE_POS)

#define FF_ENABLE	(3 << FF_MODE_POS)
#define FF_SET		(1 << FF_SC_POS)
#define FF_CLEAR	(0 << FF_SC_POS)

#define FF_ProcessorNo(logicalPNo)					\
  ( ( (logicalPNo) == 0 ) ? 0 : (logicalPNo) + 1 ) 

#define IPCR(pno)							\
  ( * ( int *) ( ipcrs_v + 					\
      ( FF_ProcessorNo(pno) << 2 | 0x400 ) )  )

#define Physical_IPCR(pno)						\
  ( * ( int *) ( FF_INTERPROCESSOR_COMM_REG_SPACE_PHYS_ADDR +           \
      ( FF_ProcessorNo(pno) << 2 | 0x400 ) )  )

/* The vector number used for interprocessor interrupts on the Firefly */
#define VecInterProcessorInt		0x204 

/* 
 * Because of a hardware hack on the Firefly, we have to store the 
 * Interprocessor Interrupt (IPI) vector at physical address 0x14 on the
 * primary processor and at physical address 0x50 for the secondary processors.
 * Reference: FPM, Section 5.
 *
 */

#define PrimaryIPIVecLoc	0x14
#define SecondaryIPIVecLoc	0x50

extern int NotPrimaryComplete;
extern int NotSecondariesComplete;

#define WaitForPrimaryProcessor()					\
  while (NotPrimaryComplete > 0)

#define WaitForSecondaryProcessors()					\
  while (NotSecondariesComplete > 0)

#define PrimaryProcessorComplete()					\
  NotPrimaryComplete--;

#define SecondaryProcessorComplete()					\
  NotSecondariesComplete--;
#endif FIREFLY_H
