/*
 * V Kernel - Copyright (c) 1985 by Stanford University, All rights reserved.
 *
 * $Revision: 1.6.1.3 $
 * $Locker:  $
 * $State: Exp $
 */
#ifndef DEQNALOCAL_H
#define DEQNALOCAL_H

#ifndef QBUSADDRESSES_H
# include "qbusaddresses.h"
#endif

#define DEQNA_BASE_ADDRESS qbus_device_to_v(017774440)

/* The MicroVAX V kernel sets up address mapping in such a way that	*/
/*		80000000+x (virtual) = x (physical) = x (Q-bus),	*/
/* so our job is trivial.  We blithely assume that the virtual address	*/
/* is between 80000000 and 803FFFFF.					*/
#define virt_to_QbusLO(addr) ((int)(addr) & 0xFFFF)
#define virt_to_QbusHI(addr) ((int)(addr) >> 16)
	/* Really ought to mask it with 0x3F after the shift */

extern void BuildSysMap_Deqna _TAKES(());
extern void InitDeqna _TAKES(());
extern void (*EnetPowerup) _TAKES(());		/* config.c */
#endif DEQNALOCAL_H
