/*
 * Distributed V Kernel
 * Copyright (c) 1986 by Stanford University, All rights reserved.
 *
 * Header file for communication between device-independent console I/O
 *   (in console.c) and the keyboard drivers.
 *
 * $Revision: 1.1.1.2 $
 * $Locker:  $
 * $State: Exp $
 */

#ifndef CONSOLE_H
#define CONSOLE_H

#include <prototypes.h>
#include <Venviron.h>
#include <Vkeyboard.h>
#include "process.h"
#include "devman.h"

/*
 * Hooks for keyboards:
 */
extern ResponseCode (*ConsoleKeyboardSetTrans)_TAKES((int));
extern ResponseCode (*ConsoleKeyboardSetClick)_TAKES((int));
extern ResponseCode (*ConsoleKeyboardGetShift)_TAKES((int*,int*,int*));
extern void (*ConsoleBellRoutine) _TAKES(());
extern void	  (*ConsoleBellRoutine)	    _TAKES((void));

/*
 * ConsoleGotChar() : should be invoked by keyboard routines for each
 *   character (or, in raw mode, key-transition) received.
 */
extern void ConsoleGotChar _TAKES((int));
extern void InitConsole _TAKES(());
extern ResponseCode ConsoleWrite _TAKES(( Process *, DeviceInstance *));
extern ResponseCode ConsoleRead _TAKES(( Process *, DeviceInstance *));
extern ResponseCode ConsoleCreate _TAKES(( Process *, DeviceInstance *));
#endif CONSOLE_H
