/*
 *  offload.c
 *
 *  This is a netloader for files that reside at other than the
 *	default 0x1000 in the Sun workstation.
 *
 *  Tim Mann
 *	2.0: loadfile() now loads symbols
 *	2.1: Refuses to step on itself.  Asks about symbols.
 *	2.2: Option to place bheader somewhere useful
 */

#include <b.out.h>

#define TRUE 1
#define FALSE 0
#define NUL '\0'

#define jump(addr) asm("	jmp	addr")	/* Jump to address */

extern unsigned a0;	/* Hack to allow getting at registers */
extern char _start, _end;
extern char *emt_getmemsize();


main()
  {

	static char filename[101], execute[2], symbols[2];
	char *program;
	unsigned limit;
	struct bhdr bh;
	struct bhdr *bheader;

	/* Sign on and prompt for program name */
	printf("\n\nSun Offset Loader - Version 2.2 - 2 Feb 1983\n");
	printf("Loader resides from %x to %x\n\n",&_start,&_end);
	printf("Program to load: ");
	scanf("%100s",filename);
	printf("Origin (hex): ");
	scanf("%x",&program);
	printf("Place b.out header at (hex; 0 if not needed): ");
	scanf("%x",&bheader);
	if (bheader == 0) bheader = &bh;
	printf("Load symbols? (y/n): ");
	scanf("%1s",symbols);
	printf("Execute? (y/n): ");
	scanf("%1s",execute);

	if (program < &_start)
		limit = &_start - program;
	else if (program > &_end)
		limit = emt_getmemsize() - program;
	else
	  {
		printf("?Program would overwrite loader.\n");
		exit();
	  }

	/* Read in program */
	loadfile(filename,bheader,program,limit,(*symbols=='y'),TRUE,"");
	
	if (*execute == 'y')
	  {
		/* Start it */
		a0 =  bheader->entry;
		jump(a0@);
	  }

  }
