/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/*
 * This file contains the definitions for the stipple patterns to be
 * used in drawing rectangles.  It also contains the routine which
 * draws the rectangles in terms of the indices of these stipple patterns.
 */

#include "Vgts.h"

static short MetalStip[] = {
		 	0xCCCC, 0x3333, 0xFFFF, 0xFFFF,
			0xCCCC, 0x3333, 0xFFFF, 0xFFFF,
			0xCCCC, 0x3333, 0xFFFF, 0xFFFF,
			0xCCCC, 0x3333, 0xFFFF, 0xFFFF };

static short PolyStip[] = {
			0x7777, 0xBBBB, 0xDDDD, 0xEEEE,
			0x7777, 0xBBBB, 0xDDDD, 0xEEEE,
			0x7777, 0xBBBB, 0xDDDD, 0xEEEE,
			0x7777, 0xBBBB, 0xDDDD, 0xEEEE };

static short DiffStip[] = {
			0xBBBB, 0xFFFF, 0xEEEE, 0xFFFF,
			0xBBBB, 0xFFFF, 0xEEEE, 0xFFFF,
			0xBBBB, 0xFFFF, 0xEEEE, 0xFFFF,
			0xBBBB, 0xFFFF, 0xEEEE, 0xFFFF };

static short IonStip[] = {
			0xBBBB, 0xFFFF, 0xBBBB, 0xFFFF,
			0xBBBB, 0xFFFF, 0xBBBB, 0xFFFF,
			0xBBBB, 0xFFFF, 0xBBBB, 0xFFFF,
			0xBBBB, 0xFFFF, 0xBBBB, 0xFFFF };

static short CutStip[] = {
			0xCCCCb, 0x4444, 0x7777, 0x1111,
			0xCCCCb, 0x4444, 0x7777, 0x1111,
			0xCCCCb, 0x4444, 0x7777, 0x1111,
			0xCCCCb, 0x4444, 0x7777, 0x1111 };

static short GlassStip[] = {
			0x9999, 0x6666, 0x6666, 0x9999,
			0x9999, 0x6666, 0x6666, 0x9999,
			0x9999, 0x6666, 0x6666, 0x9999,
			0x9999, 0x6666, 0x6666, 0x9999 };

/*
 * Tom Davis made these up -- the others come from 
 * Kevin Karplus
 */

static short BuriedStip[] = {
			0x0F0F, 0xF0F0, 0x0F0F, 0xF0F0,
			0x0F0F, 0xF0F0, 0x0F0F, 0xF0F0,
			0x0F0F, 0xF0F0, 0x0F0F, 0xF0F0,
			0x0F0F, 0xF0F0, 0x0F0F, 0xF0F0 };

static short BlackStip[] = {
			0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000 };

static short GrayStip[] = {
			0x5555, 0xAAAA, 0x5555, 0xAAAA,
			0x5555, 0xAAAA, 0x5555, 0xAAAA,
			0x5555, 0xAAAA, 0x5555, 0xAAAA,
			0x5555, 0xAAAA, 0x5555, 0xAAAA };

extern short GridStip[];

/*
 * DrawRect:
 * Draws a rectangle at screen coords. (x, y) of height h and width w.
 * The rectangle is drawn with a stipple pattern whose index is indicated
 * by the value of layer. 
 */

DrawRect(x, y, w, h, layer)
short x, y, w, h;
unsigned char layer;
{
  short *stip_ptr;

  switch (layer)
    {
      case NP: stip_ptr = PolyStip; break;
      case NM: stip_ptr = MetalStip; break;
      case ND: stip_ptr = DiffStip; break;
      case NI: stip_ptr = IonStip; break;
      case NG: stip_ptr = GlassStip; break;
      case NB: stip_ptr = BuriedStip; break;
      case NC: stip_ptr = CutStip; break;
      case ZZ: stip_ptr = GridStip; break;	/* draws a grid */
      case BLACK: stip_ptr = BlackStip; break;	/* draws solid black */
      case GRAY:  stip_ptr = GrayStip; break;	/* gray  */
      case HILIGHT: stip_ptr = DiffStip; break;	/* like ND, but unselectable  */
      default: return;				/* Error */
    }
  DrawRectangle(x, y, w, h, stip_ptr);
}
