/************************************************/
/*						*/
/*	       (C)  COPYRIGHT 1983		*/
/*		BOARD OF TRUSTEES		*/
/*	LELAND STANFORD JUNIOR UNIVERSITY	*/
/*	  STANFORD, CA. 94305, U. S. A.		*/
/*						*/
/************************************************/
 
/*
 *  splinedefs.c
 *
 *  This file contains the values of the spline blending function of
 *  various orders.  In particular, orders 2 though 5 are represented.
 *  The B-Spline coefficients were evaluated at intervals of 1/k,
 *  (where k is equal to the value (1 << XYsplineRes)),
 *  and then multiplied by 1<<16 to avoid floating calculations.
 *  Closed end-conditions were used.  See also splinegen.c for the
 *  program which generated these points.  The points are generated
 *  in a matrix form, with the 'y' axis running from 0.0 to 1.0, and
 *  each row containing values at locations y, y+1, .., y+order.
 *
 *  Update History:
 *	March 1983 -- Written by David Kaelbling.
 */
 
 
/* Exports */
extern short XYsplineRes;
extern unsigned short spline2[];
extern unsigned short spline3[];
extern unsigned short spline4[];
extern unsigned short spline5[];
    
/* Define and declare the resolution constant */
short XYsplineRes = 6;		/* Maximum of 64 subintervals */
    
/* Coefficients for a linear (k=2) B-spline */
unsigned short spline2[] =
  {
    0x0000,    0xffff,
    0x0400,    0xfc00,
    0x0800,    0xf800,
    0x0c00,    0xf400,
    0x1000,    0xf000,
    0x1400,    0xec00,
    0x1800,    0xe800,
    0x1c00,    0xe400,
    0x2000,    0xe000,
    0x2400,    0xdc00,
    0x2800,    0xd800,
    0x2c00,    0xd400,
    0x3000,    0xd000,
    0x3400,    0xcc00,
    0x3800,    0xc800,
    0x3c00,    0xc400,
    0x4000,    0xc000,
    0x4400,    0xbc00,
    0x4800,    0xb800,
    0x4c00,    0xb400,
    0x5000,    0xb000,
    0x5400,    0xac00,
    0x5800,    0xa800,
    0x5c00,    0xa400,
    0x6000,    0xa000,
    0x6400,    0x9c00,
    0x6800,    0x9800,
    0x6c00,    0x9400,
    0x7000,    0x9000,
    0x7400,    0x8c00,
    0x7800,    0x8800,
    0x7c00,    0x8400,
    0x8000,    0x8000,
    0x8400,    0x7c00,
    0x8800,    0x7800,
    0x8c00,    0x7400,
    0x9000,    0x7000,
    0x9400,    0x6c00,
    0x9800,    0x6800,
    0x9c00,    0x6400,
    0xa000,    0x6000,
    0xa400,    0x5c00,
    0xa800,    0x5800,
    0xac00,    0x5400,
    0xb000,    0x5000,
    0xb400,    0x4c00,
    0xb800,    0x4800,
    0xbc00,    0x4400,
    0xc000,    0x4000,
    0xc400,    0x3c00,
    0xc800,    0x3800,
    0xcc00,    0x3400,
    0xd000,    0x3000,
    0xd400,    0x2c00,
    0xd800,    0x2800,
    0xdc00,    0x2400,
    0xe000,    0x2000,
    0xe400,    0x1c00,
    0xe800,    0x1800,
    0xec00,    0x1400,
    0xf000,    0x1000,
    0xf400,    0x0c00,
    0xf800,    0x0800,
    0xfc00,    0x0400,
    0xffff,    0x0000,
  };

    
/* Coefficients for a quadratic (k=3) B-Spline */
unsigned short spline3[] =
  {
    0x0000,    0x8000,    0x8000,
    0x0008,    0x83f0,    0x7c08,
    0x0020,    0x87c0,    0x7820,
    0x0048,    0x8b70,    0x7448,
    0x0080,    0x8f00,    0x7080,
    0x00c8,    0x9270,    0x6cc8,
    0x0120,    0x95c0,    0x6920,
    0x0188,    0x98f0,    0x6588,
    0x0200,    0x9c00,    0x6200,
    0x0288,    0x9ef0,    0x5e88,
    0x0320,    0xa1c0,    0x5b20,
    0x03c8,    0xa470,    0x57c8,
    0x0480,    0xa700,    0x5480,
    0x0548,    0xa970,    0x5148,
    0x0620,    0xabc0,    0x4e20,
    0x0708,    0xadf0,    0x4b08,
    0x0800,    0xb000,    0x4800,
    0x0908,    0xb1f0,    0x4508,
    0x0a20,    0xb3c0,    0x4220,
    0x0b48,    0xb570,    0x3f48,
    0x0c80,    0xb700,    0x3c80,
    0x0dc8,    0xb870,    0x39c8,
    0x0f20,    0xb9c0,    0x3720,
    0x1088,    0xbaf0,    0x3488,
    0x1200,    0xbc00,    0x3200,
    0x1388,    0xbcf0,    0x2f88,
    0x1520,    0xbdc0,    0x2d20,
    0x16c8,    0xbe70,    0x2ac8,
    0x1880,    0xbf00,    0x2880,
    0x1a48,    0xbf70,    0x2648,
    0x1c20,    0xbfc0,    0x2420,
    0x1e08,    0xbff0,    0x2208,
    0x2000,    0xc000,    0x2000,
    0x2208,    0xbff0,    0x1e08,
    0x2420,    0xbfc0,    0x1c20,
    0x2648,    0xbf70,    0x1a48,
    0x2880,    0xbf00,    0x1880,
    0x2ac8,    0xbe70,    0x16c8,
    0x2d20,    0xbdc0,    0x1520,
    0x2f88,    0xbcf0,    0x1388,
    0x3200,    0xbc00,    0x1200,
    0x3488,    0xbaf0,    0x1088,
    0x3720,    0xb9c0,    0x0f20,
    0x39c8,    0xb870,    0x0dc8,
    0x3c80,    0xb700,    0x0c80,
    0x3f48,    0xb570,    0x0b48,
    0x4220,    0xb3c0,    0x0a20,
    0x4508,    0xb1f0,    0x0908,
    0x4800,    0xb000,    0x0800,
    0x4b08,    0xadf0,    0x0708,
    0x4e20,    0xabc0,    0x0620,
    0x5148,    0xa970,    0x0548,
    0x5480,    0xa700,    0x0480,
    0x57c8,    0xa470,    0x03c8,
    0x5b20,    0xa1c0,    0x0320,
    0x5e88,    0x9ef0,    0x0288,
    0x6200,    0x9c00,    0x0200,
    0x6588,    0x98f0,    0x0188,
    0x6920,    0x95c0,    0x0120,
    0x6cc8,    0x9270,    0x00c8,
    0x7080,    0x8f00,    0x0080,
    0x7448,    0x8b70,    0x0048,
    0x7820,    0x87c0,    0x0020,
    0x7c08,    0x83f0,    0x0008,
    0x8000,    0x8000,    0x0000,
  };

/* Coefficients for a qubic (k=4) B-Spline */
unsigned short spline4[] =
  {
    0x0000,    0x2aab,    0xaaab,    0x2aab,
    0x0000,    0x2cb3,    0xaa9b,    0x28b3,
    0x0000,    0x2eca,    0xaa6c,    0x26ca,
    0x0001,    0x30ef,    0xaa1e,    0x24f2,
    0x0003,    0x3323,    0xa9b3,    0x2328,
    0x0005,    0x3563,    0xa92a,    0x216d,
    0x0009,    0x37b0,    0xa886,    0x1fc2,
    0x000e,    0x3a08,    0xa7c6,    0x1e24,
    0x0015,    0x3c6b,    0xa6eb,    0x1c95,
    0x001e,    0x3ed8,    0xa5f6,    0x1b14,
    0x002a,    0x414e,    0xa4e8,    0x19a1,
    0x0037,    0x43cc,    0xa3c1,    0x183b,
    0x0048,    0x4653,    0xa283,    0x16e3,
    0x005c,    0x48e0,    0xa12d,    0x1597,
    0x0072,    0x4b74,    0x9fc2,    0x1458,
    0x008d,    0x4e0d,    0x9e41,    0x1326,
    0x00ab,    0x50ab,    0x9cab,    0x1200,
    0x00cd,    0x534d,    0x9b01,    0x10e6,
    0x00f3,    0x55f2,    0x9944,    0x0fd8,
    0x011e,    0x5899,    0x9774,    0x0ed5,
    0x014d,    0x5b43,    0x9593,    0x0ddd,
    0x0182,    0x5ded,    0x93a0,    0x0cf1,
    0x01bc,    0x6098,    0x919e,    0x0c0f,
    0x01fb,    0x6342,    0x8f8c,    0x0b38,
    0x0240,    0x65eb,    0x8d6b,    0x0a6b,
    0x028b,    0x6892,    0x8b3c,    0x09a8,
    0x02dc,    0x6b36,    0x8900,    0x08ee,
    0x0334,    0x6dd6,    0x86b7,    0x083f,
    0x0393,    0x7073,    0x8463,    0x0798,
    0x03f8,    0x730a,    0x8203,    0x06fa,
    0x0465,    0x759c,    0x7f9a,    0x0666,
    0x04d9,    0x7827,    0x7d27,    0x05d9,
    0x0555,    0x7aab,    0x7aab,    0x0555,
    0x05d9,    0x7d27,    0x7827,    0x04d9,
    0x0666,    0x7f9a,    0x759c,    0x0465,
    0x06fa,    0x8203,    0x730a,    0x03f8,
    0x0798,    0x8463,    0x7073,    0x0393,
    0x083f,    0x86b7,    0x6dd6,    0x0334,
    0x08ee,    0x8900,    0x6b36,    0x02dc,
    0x09a8,    0x8b3c,    0x6892,    0x028b,
    0x0a6b,    0x8d6b,    0x65eb,    0x0240,
    0x0b38,    0x8f8c,    0x6342,    0x01fb,
    0x0c0f,    0x919e,    0x6098,    0x01bc,
    0x0cf1,    0x93a0,    0x5ded,    0x0182,
    0x0ddd,    0x9593,    0x5b43,    0x014d,
    0x0ed5,    0x9774,    0x5899,    0x011e,
    0x0fd8,    0x9944,    0x55f2,    0x00f3,
    0x10e6,    0x9b01,    0x534d,    0x00cd,
    0x1200,    0x9cab,    0x50ab,    0x00ab,
    0x1326,    0x9e41,    0x4e0d,    0x008d,
    0x1458,    0x9fc2,    0x4b74,    0x0072,
    0x1597,    0xa12d,    0x48e0,    0x005c,
    0x16e3,    0xa283,    0x4653,    0x0048,
    0x183b,    0xa3c1,    0x43cc,    0x0037,
    0x19a1,    0xa4e8,    0x414e,    0x002a,
    0x1b14,    0xa5f6,    0x3ed8,    0x001e,
    0x1c95,    0xa6eb,    0x3c6b,    0x0015,
    0x1e24,    0xa7c6,    0x3a08,    0x000e,
    0x1fc2,    0xa886,    0x37b0,    0x0009,
    0x216d,    0xa92a,    0x3563,    0x0005,
    0x2328,    0xa9b3,    0x3323,    0x0003,
    0x24f2,    0xaa1e,    0x30ef,    0x0001,
    0x26ca,    0xaa6c,    0x2eca,    0x0000,
    0x28b3,    0xaa9b,    0x2cb3,    0x0000,
    0x2aab,    0xaaab,    0x2aab,    0x0000,
  };

/* Coefficients for a quartic (k=5) B-Spline */
unsigned short spline5[] =
  {
    0x0000,    0x0aab,    0x7555,    0x7555,    0x0aab,
    0x0000,    0x0b59,    0x7751,    0x7351,    0x0a04,
    0x0000,    0x0c10,    0x7944,    0x7146,    0x0965,
    0x0000,    0x0cd0,    0x7b2e,    0x6f35,    0x08ce,
    0x0000,    0x0d98,    0x7d0e,    0x6d1d,    0x083d,
    0x0000,    0x0e69,    0x7ee2,    0x6b01,    0x07b4,
    0x0000,    0x0f43,    0x80ac,    0x68df,    0x0732,
    0x0000,    0x1026,    0x8269,    0x66bb,    0x06b6,
    0x0001,    0x1113,    0x8419,    0x6493,    0x0641,
    0x0001,    0x1209,    0x85bd,    0x6268,    0x05d1,
    0x0002,    0x1308,    0x8752,    0x603c,    0x0568,
    0x0002,    0x1412,    0x88d9,    0x5e0e,    0x0504,
    0x0003,    0x1525,    0x8a52,    0x5be0,    0x04a6,
    0x0005,    0x1642,    0x8bbb,    0x59b1,    0x044d,
    0x0006,    0x1769,    0x8d14,    0x5783,    0x03f9,
    0x0008,    0x189a,    0x8e5d,    0x5556,    0x03aa,
    0x000b,    0x19d5,    0x8f95,    0x532b,    0x0360,
    0x000e,    0x1b1a,    0x90bd,    0x5101,    0x031a,
    0x0011,    0x1c69,    0x91d3,    0x4eda,    0x02d9,
    0x0015,    0x1dc2,    0x92d7,    0x4cb6,    0x029b,
    0x001a,    0x1f25,    0x93ca,    0x4a95,    0x0262,
    0x0020,    0x2092,    0x94aa,    0x4878,    0x022c,
    0x0026,    0x2208,    0x9577,    0x4660,    0x01fa,
    0x002e,    0x2389,    0x9632,    0x444c,    0x01cc,
    0x0036,    0x2513,    0x96d9,    0x423d,    0x01a1,
    0x0040,    0x26a6,    0x976e,    0x4034,    0x0179,
    0x004a,    0x2843,    0x97ef,    0x3e31,    0x0153,
    0x0056,    0x29e9,    0x985c,    0x3c34,    0x0131,
    0x0064,    0x2b98,    0x98b6,    0x3a3d,    0x0111,
    0x0073,    0x2d50,    0x98fb,    0x384d,    0x00f4,
    0x0084,    0x2f10,    0x992d,    0x3665,    0x00da,
    0x0096,    0x30d9,    0x994b,    0x3484,    0x00c1,
    0x00ab,    0x32ab,    0x9955,    0x32ab,    0x00ab,
    0x00c1,    0x3484,    0x994b,    0x30d9,    0x0096,
    0x00da,    0x3665,    0x992d,    0x2f10,    0x0084,
    0x00f4,    0x384d,    0x98fb,    0x2d50,    0x0073,
    0x0111,    0x3a3d,    0x98b6,    0x2b98,    0x0064,
    0x0131,    0x3c34,    0x985c,    0x29e9,    0x0056,
    0x0153,    0x3e31,    0x97ef,    0x2843,    0x004a,
    0x0179,    0x4034,    0x976e,    0x26a6,    0x0040,
    0x01a1,    0x423d,    0x96d9,    0x2513,    0x0036,
    0x01cc,    0x444c,    0x9632,    0x2389,    0x002e,
    0x01fa,    0x4660,    0x9577,    0x2208,    0x0026,
    0x022c,    0x4878,    0x94aa,    0x2092,    0x0020,
    0x0262,    0x4a95,    0x93ca,    0x1f25,    0x001a,
    0x029b,    0x4cb6,    0x92d7,    0x1dc2,    0x0015,
    0x02d9,    0x4eda,    0x91d3,    0x1c69,    0x0011,
    0x031a,    0x5101,    0x90bd,    0x1b1a,    0x000e,
    0x0360,    0x532b,    0x8f95,    0x19d5,    0x000b,
    0x03aa,    0x5556,    0x8e5d,    0x189a,    0x0008,
    0x03f9,    0x5783,    0x8d14,    0x1769,    0x0006,
    0x044d,    0x59b1,    0x8bbb,    0x1642,    0x0005,
    0x04a6,    0x5be0,    0x8a52,    0x1525,    0x0003,
    0x0504,    0x5e0e,    0x88d9,    0x1412,    0x0002,
    0x0568,    0x603c,    0x8752,    0x1308,    0x0002,
    0x05d1,    0x6268,    0x85bd,    0x1209,    0x0001,
    0x0641,    0x6493,    0x8419,    0x1113,    0x0001,
    0x06b6,    0x66bb,    0x8269,    0x1026,    0x0000,
    0x0732,    0x68df,    0x80ac,    0x0f43,    0x0000,
    0x07b4,    0x6b01,    0x7ee2,    0x0e69,    0x0000,
    0x083d,    0x6d1d,    0x7d0e,    0x0d98,    0x0000,
    0x08ce,    0x6f35,    0x7b2e,    0x0cd0,    0x0000,
    0x0965,    0x7146,    0x7944,    0x0c10,    0x0000,
    0x0a04,    0x7351,    0x7751,    0x0b59,    0x0000,
    0x0aab,    0x7555,    0x7555,    0x0aab,    0x0000,
  };
