/************************************************/
/*						*/
/*	       (C)  COPYRIGHT 1983		*/
/*		BOARD OF TRUSTEES		*/
/*	LELAND STANFORD JUNIOR UNIVERSITY	*/
/*	  STANFORD, CA. 94305, U. S. A.		*/
/*						*/
/************************************************/
 
/*
 *  patdefs.c
 *
 *  This file defines all of the various fill patterns used in the
 *  XY system.  By convention, a 1 bit represents a white pixel.
 *
 *  Update History:
 *	March 1983 -- Written by David Kaelbling.
 */
    
    
/* Exports */
extern short *Patterns[];
    
    
/* Local definitions */
static short White[] =
  {
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  };
    
static short Black[] =
  {
    0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000,
  };
    
static short Gray[] =
  {
    0x5555, 0xAAAA, 0x5555, 0xAAAA,
    0x5555, 0xAAAA, 0x5555, 0xAAAA,
    0x5555, 0xAAAA, 0x5555, 0xAAAA,
    0x5555, 0xAAAA, 0x5555, 0xAAAA,
  };
    
static short StripeLeft[] =
  {
    0xCCCC, 0x6666, 0x3333, 0x9999,
    0xCCCC, 0x6666, 0x3333, 0x9999,
    0xCCCC, 0x6666, 0x3333, 0x9999,
    0xCCCC, 0x6666, 0x3333, 0x9999,
  };
    
static short BigStripeLeft[] =
  {
    0xf0f0, 0x7878, 0x3c3c, 0x1e1e,
    0x0f0f, 0x8787, 0xc3c3, 0xe1e1,
    0xf0f0, 0x7878, 0x3c3c, 0x1e1e,
    0x0f0f, 0x8787, 0xc3c3, 0xe1e1,
  };
    
static short StripeRight[] =
  {
    0x3333, 0x6666, 0xCCCC, 0x9999,
    0x3333, 0x6666, 0xCCCC, 0x9999,
    0x3333, 0x6666, 0xCCCC, 0x9999,
    0x3333, 0x6666, 0xCCCC, 0x9999,
  };
    
static short BigStripeRight[] =
  {
    0x0f0f, 0x1e1e, 0x3c3c, 0x7878,
    0xf0f0, 0xe1e1, 0xc3c3, 0x8787,
    0x0f0f, 0x1e1e, 0x3c3c, 0x7878,
    0xf0f0, 0xe1e1, 0xc3c3, 0x8787,
  };
    
static short CrossHatch[] =
  {
    0x7777, 0xAAAA, 0xDDDD, 0xAAAA,
    0x7777, 0xAAAA, 0xDDDD, 0xAAAA,
    0x7777, 0xAAAA, 0xDDDD, 0xAAAA,
    0x7777, 0xAAAA, 0xDDDD, 0xAAAA,
  };
    
static short BigCrossHatch[] =
  {
    0x1818, 0x3c3c, 0x1818, 0x0000,
    0x8181, 0xc3c3, 0x8181, 0x0000,
    0x1818, 0x3c3c, 0x1818, 0x0000,
    0x8181, 0xc3c3, 0x8181, 0x0000,
  };
    
static short ChainLink[] =
  {
    0x3C3C, 0x9999, 0xC3C3, 0x9999,
    0x3C3C, 0x9999, 0xC3C3, 0x9999,
    0x3C3C, 0x9999, 0xC3C3, 0x9999,
    0x3C3C, 0x9999, 0xC3C3, 0x9999,
  };
  
static short Dots[] =
  {
    0xCCCC, 0xCCCC, 0x3333, 0x3333,
    0xCCCC, 0xCCCC, 0x3333, 0x3333,
    0xCCCC, 0xCCCC, 0x3333, 0x3333,
    0xCCCC, 0xCCCC, 0x3333, 0x3333,
  };
  
static short Checkers[] =
  {
    0xC3C3, 0xC3C3, 0x3C3C, 0x3C3C,
    0x3C3C, 0x3C3C, 0xC3C3, 0xC3C3,
    0xC3C3, 0xC3C3, 0x3C3C, 0x3C3C,
    0x3C3C, 0x3C3C, 0xC3C3, 0xC3C3,
  };
    
static short SquareDots[] =	/* by Mistake */
  {
    0xF0F0, 0x9696, 0x9696, 0xF0F0,
    0x0F0F, 0x6969, 0x6969, 0x0F0F,
    0xF0F0, 0x9696, 0x9696, 0xF0F0,
    0x0F0F, 0x6969, 0x6969, 0x0F0F,
  };
    
static short Pinwheels[] =	/* by J.E.B */
  {
    0x2222, 0xEEEE, 0x7777, 0x4444,
    0x2222, 0xEEEE, 0x7777, 0x4444,
    0x2222, 0xEEEE, 0x7777, 0x4444,
    0x2222, 0xEEEE, 0x7777, 0x4444,
  };
    
static short Roses[] =		/* by J.E.B. */
  {
    0x0E0E, 0xFAFA, 0x8282, 0xDADA,
    0x5B5B, 0x4141, 0x5F5F, 0x7070,
    0x0E0E, 0xFAFA, 0x8282, 0xDADA,
    0x5B5B, 0x4141, 0x5F5F, 0x7070,
  };
    
static short Math[] =		/* by D.P.H. */
  {
    0x3939, 0x1010, 0x8282, 0xC6C6,
    0x8282, 0x1010, 0x3939, 0x8383,
    0x3939, 0x1010, 0x8282, 0xC6C6,
    0x8282, 0x1010, 0x3939, 0x8383,
  };
    
static short Rug[] =		/* by J.D.M. */
  {
    0x4892, 0x9549, 0x2024, 0x5D1A,
    0x9499, 0x5D24, 0x0242, 0x5491,
    0x892A, 0x4240, 0x24Ba, 0x9929,
    0x58BA, 0x2404, 0x92A9, 0x4912,
  };
    
static short DeskTop[] =	/* by P.J.A. */
  {
    0x2222, 0x2222, 0x8888, 0x8888, 
    0x2222, 0x2222, 0x8888, 0x8888, 
    0x2222, 0x2222, 0x8888, 0x8888, 
    0x2222, 0x2222, 0x8888, 0x8888, 
  };
    
static short Cubes[] =		/* by P.J.A. */
  {
    0x1919, 0x6767, 0x8181, 0x6767,
    0x1919, 0x1111, 0x1111, 0x1111,
    0x9191, 0x7676, 0x1818, 0x7676,
    0x9191, 0x1111, 0x1111, 0x1111,
  };    

static short Wicker[] =		/* by the program itself */
  {
    0x2020, 0x2c2c, 0x4343, 0x4040,
    0x0202, 0xc2c2, 0x3434, 0x0404,
    0x2020, 0x2c2c, 0x4343, 0x4040,
    0x0202, 0xc2c2, 0x3434, 0x0404,
  };
 
static short Herringbone[] =	/* by L.E.P. */
  {
    0x9393, 0xc6c6, 0x6c6c, 0x3939,
    0x9393, 0xc6c6, 0x6c6c, 0x3939,
    0x9393, 0xc6c6, 0x6c6c, 0x3939,
    0x9393, 0xc6c6, 0x6c6c, 0x3939,
  };
  
static short Tangle[] =		/* by committee */
  {
    0xdcdc, 0xc8c8, 0xc0c0, 0xe4e4,
    0xf6f6, 0x2626, 0x0606, 0x4e4e,
    0xdcdc, 0xc8c8, 0xc0c0, 0xe4e4,
    0xf6f6, 0x2626, 0x0606, 0x4e4e,
  };
    
static short Web[] =		/* by D.P.H. */
  {
    0xaafe, 0xaa00, 0xaafe, 0xaa00,
    0xaafe, 0xaa00, 0xaafe, 0xaa00,
    0xfeaa, 0x00aa, 0xfeaa, 0x00aa,
    0xfeaa, 0x00aa, 0xfeaa, 0x00aa,
  };
    
static short Weave[] =		/* by L.E.P. */
  {
    0x7fca, 0x000a, 0x7fca, 0x000a,
    0x000a, 0x0a0a, 0x0a00, 0x0a00,
    0xca7f, 0x0a00, 0xca7f, 0x0a00,
    0x0a00, 0x0a0a, 0x000a, 0x000a,
  };
    
static short Trees[] =		/* by L.E.P. */
  {
    0xfffc, 0xfffc, 0x033c, 0x033c,
    0xc30c, 0xc30c, 0xf300, 0xf300,
    0xfffc, 0xfffc, 0x033c, 0x033c,
    0xc30c, 0xc30c, 0xf300, 0xf300,
  };
    
static short Columns[] =
  {
    0xcccc, 0xcccc, 0xcccc, 0xcccc,
    0xcccc, 0xcccc, 0xcccc, 0xcccc,
    0xcccc, 0xcccc, 0xcccc, 0xcccc,
    0xcccc, 0xcccc, 0xcccc, 0xcccc,
  };
    
static short Rows[] =
  {
    0xffff, 0xffff, 0x0000, 0x0000,
    0xffff, 0xffff, 0x0000, 0x0000,
    0xffff, 0xffff, 0x0000, 0x0000,
    0xffff, 0xffff, 0x0000, 0x0000,
  };
    
static short Matrix[] =
  {
    0xcccc, 0xcccc, 0x0000, 0x0000,
    0xcccc, 0xcccc, 0x0000, 0x0000,
    0xcccc, 0xcccc, 0x0000, 0x0000,
    0xcccc, 0xcccc, 0x0000, 0x0000,
  };
    
/* Export an array of these definitions */
short *Patterns[] =
  {
    White,
    Black,
    Gray,
    StripeLeft,
    BigStripeLeft,
    StripeRight,
    BigStripeRight,
    CrossHatch,
    BigCrossHatch,
    ChainLink,
    Dots,
    Checkers,
    SquareDots,
    Pinwheels,
    Roses,
    Math,
    Rug,
    DeskTop,
    Cubes,
    Wicker,
    Herringbone,
    Tangle,
    Web,
    Weave,
    Trees,
    Columns,
    Rows,
    Matrix,
  };
