/************************************************/
/*						*/
/*	       (C)  COPYRIGHT 1983		*/
/*		BOARD OF TRUSTEES		*/
/*	LELAND STANFORD JUNIOR UNIVERSITY	*/
/*	  STANFORD, CA. 94305, U. S. A.		*/
/*						*/
/************************************************/
 
/*
 *  nibdefs.c
 *
 *  This file contains all of the actual MEM_RASTERs for all
 *  of the nibs used in the program.
 *
 *  Update History:
 *	March 1983 -- Written by David Kaelbling.
 */
    
    
#include <rasterops.h>
    
    
/* Necessary internal declarations for Exports */
static short xSquare[16] =
  {
    0xFF00, 0xFF00, 0xFF00, 0xFF00,
    0xFF00, 0xFF00, 0xFF00, 0xFF00,
    0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000,
  };
  
static short xCircle3[16] =
  {
    0x4000, 0xe000, 0x4000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000,
  };
  
static short xCircle5[16] =
  {
    0x7000, 0xf800, 0xf800, 0xf800,
    0x7000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000,
  };
  
static short xCircle7[16] =
  {
    0x3800, 0x7c00, 0xfe00, 0xfe00,
    0xfe00, 0x7c00, 0x3800, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000,
  };
    
    
/* Exports */
struct mem_raster Nibs[] =
  {
    {1, 1, xSquare},	/* NibSquare0 */
    {3, 3, xSquare},	/* NibSquare1 */
    {5, 5, xSquare},	/* NibSquare2 */
    {7, 7, xSquare},	/* NibSquare3 */
    {1, 1, xSquare},    /* NibCircle0 */
    {3, 3, xCircle3},	/* NibCircle1 */
    {5, 5, xCircle5},	/* NibCircle2 */
    {7, 7, xCircle7},	/* NibCircle3 */
    {1, 1, xSquare},	/* NibDash0 */
    {1, 3, xSquare},	/* NibDash1 */
    {1, 5, xSquare},	/* NibDash2 */
    {1, 7, xSquare},	/* NibDash3 */
    {1, 1, xSquare},	/* NibBar0 */
    {3, 1, xSquare},	/* NibBar1 */
    {5, 1, xSquare},	/* NibBar2 */
    {7, 1, xSquare},	/* NibBar3 */
  };
