/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/*
 * keyboard.c - keyboard helper process 
 *
 * Bill Nowicki November 1982
 */

# include <Venviron.h>
# include <confreg.h>
# include <chars.h>
# include <Vgts.h>
# include <Vioprotocol.h>
# include "client.h"

extern Process_id VgtsPid;
extern short InputPad, TtyVGT;

KeyboardProcess()
  {
	/*
	 * read chars from the keyboard and send them to the Vgts
	 */
    short isCadlinc, conf;
    IoRequest msg;
    extern short emt_getconfig();
    register char c;

    conf = emt_getconfig();
    isCadlinc =  ( (struct ConfReg *)( &conf ) )->ConsSpeed == 2;
    while (1)
      {
         c = getchar();
	 if ( c == EOF && stdin->lastexception == BAD_BLOCK_NO )
	   {
	     Resynch(stdin);
	     c = getchar();
	   }
	 msg.requestcode = (int)Keyboard;
	 msg.fileid = 0;
	 if (c & 0200 && isCadlinc)
	  switch ( c&0177 )
	    {
	     case 'v':  Select(1);		continue;
	     case 'w':  Select(2);		continue;
	     case 'x':  Select(3);		continue;
	     case 'y':  Select(4);		continue;
	     case 'C':	/* "Enter" */		continue;
	     case 'q':  Arrow('A');		continue;
	     case 'r':  Arrow('B');		continue;
	     case 's':  Arrow('D');		continue;
	     case 't':  Arrow('C');		continue;
	     case 'S':	Quit();
	    }
	 if (!isCadlinc) c &= 0177;
         msg.shortbuffer[0] = c;
	 if (c==TELNET_ESCAPE)
	   {
	   	/*
		 * Decode local window commands for those who do not have
		 * a mouse, or like using the keyboard.
		 */
	     char temp = getchar();

	     switch ( (int)(temp & 0177) )
	       {
	         case 'C':
	         case 'c':
	         case 'D':
	         case 'd':
		 case 'E':
		 case 'e':
		 case 'o':
		 case 'B':
		 case 'b':
		 case 'O':
		 case TELNET_ESCAPE:
		   Send( &msg, VgtsPid );
	 	   msg.requestcode = (int)Keyboard;
	           msg.shortbuffer[0] = temp;
		   msg.fileid = 0;
		   break;

	         case '1':  
	         case '2':  
	         case '3':
	         case '4':  
	         case '5':  
	         case '6':  
	         case '7':  
	         case '8':  
	         case '9':  
		 	    Select(temp-'0');
			    			continue;
		 default:   Select(-1);		continue;
	       }
	   }
	 Send( &msg, VgtsPid);
      }
  }


static Arrow(c)
 char c;
  {
  	/*
	 * Send an ANSI escape sequence for an arrow key
	 */
   IoRequest msg;

    msg.requestcode = (int)Keyboard;
    msg.shortbuffer[0] = ESC;
    msg.fileid = 0;
    Send( &msg, VgtsPid );
    msg.requestcode = (int)Keyboard;
    msg.shortbuffer[0] = '[';
    Send( &msg, VgtsPid );
    msg.requestcode = (int)Keyboard;
    msg.shortbuffer[0] = c;
    Send( &msg, VgtsPid );   
  }

/*
 * GetInputChar:
 * Call for next keyboard input character from the vgts.
 */

char GetInputChar()
  {
    short savePad = InputPad;
    IoReply msg;
    
    InputPad = TtyVGT;
    GetMessage( 0, 1, &msg);
    InputPad = savePad;
    return((char) msg.shortbuffer[0]);
  }


static Select(n)
  {
  	/*
	 * select for input. This routine is called from the
	 * keyboard process.
	 */
    IoRequest msg;
     
     msg.requestcode = (SystemCode)SwitchInput;
     msg.fileid = n;
     Send(&msg,VgtsPid);
  }
