/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1983			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/* dir.c - Directory Protocol implementation for the VGTS
 *
 *
 * Bill Nowicki September 1983
 *
 */

# include <Vioprotocol.h>
# include <Vdirectory.h>
# include "Vgts.h"
# include "client.h"
# include "sdf.h"
# include "pad.h"

extern short Debug;
static VgtDescriptor buf;

HandleDirectoryRead(msg,pid)
    register IoRequest *msg;
  {
      /*
       * read the indicated "block" of the directory
       */
     short vgt = msg->blocknumber;
     VGT *v = VGTtable + vgt;
     register struct Client *client;
     
     if (vgt >= DirectoryInstance)
       {
         msg->requestcode = END_OF_FILE;
	 msg->bytecount = 0;
	 Reply(msg,pid);
	 return;
       }
     if (msg->bytecount > VgtDescriptorSize() )
       {
         msg->requestcode = BAD_BYTE_COUNT;
	 msg ->bytecount = 0;
	 Reply(msg,pid);
	 return;
       }
     if (Debug) printf("Reading descriptor for vgt %d\n", vgt);
     client = ClientTable + vgt;
     buf.typeVGT = v->type;
     if (v->type != UNUSED)
       {
         buf.descriptortype = VGT_DESCRIPTOR;
         strcpy( buf.name, v->name);
	 if (v->banner)
	   strncpy( buf.banner, v->banner, VgtBannerLength);
	 else
	   strcpy( buf.banner, "");
	 if (v->type & TTY)
	   {
	     buf.lines = TtyPadList[vgt].length+1;
	     buf.columns = TtyPadList[vgt].width+1;
	   }
	 else
	   {
	     buf.lines = 0;
	     buf.columns = 0;
	   }
	 buf.mode = client->mode;
	 buf.vgt = client->vgt;
	 buf.master = client->master;
	 buf.ownerPid = client->owner;
	 buf.breakPid = client->termPid;
	 buf.fileid = vgt;
        }
      else buf.descriptortype = EMPTY_DESCRIPTOR;
      msg->requestcode = MoveTo(pid,msg->bufferptr,&buf,msg->bytecount);
      if (msg->requestcode != OK) msg->bytecount = 0;
      Reply(msg,pid);     
  }

VgtDescriptorSize()
  { return sizeof buf; }
