/*
 * The V UNIX server: a V kernel and V server simulator for VAX/UNIX
 * that provides a subset of UNIX system services to SUN workstations
 * running the V distributed kernel.
 * Copyright (c) 1982 David R. Cheriton, all rights reserved.
 */


/*
 * Normal lookup uses a the standard "bbn" internet routines.
 *
 * Simple lookup has its own table which is V specific.
 */
#include <Venviron.h>
#include <debug.h>
#include <kernel.h>

#ifndef SIMPLELOOKUP
#include <net/netlib.h>

ProcessId GetServerPid( host )
    char *host;
  {
    netaddr addr;

    if ( LDebug )
	  printf( "GetServerPid: %s\n", host );

    if ( isbadhost( addr = gethost( host ) ) || !islocal( addr ) )
        return( 0 );

    /* addr._na_l is the internet address 
       and MAIN_SERVER_PID is the logical pid */
    return( (addr._na_l&0xFF000000) + MAIN_SERVER_PID );
    
  } /* GetServerPid */

char *GetSessionOwnerName( pid )
    ProcessId pid;
  {
/*
 * Lookup the name for the host of the pid.
 */
    char *SessionOwnerName;
    netaddr addr;
    static long MyAddress = 0;
    
    if ( MyAddress == 0 )
      {
	/* MyAddress is everything but the local address */
	addr = thishost( thisnet() );
        MyAddress = 0xFFFFFF & addr._na_l;
      }

    /* take the pid's "address" and insert it into MyAddress */
    addr._na_l =  MyAddress | ( pid & 0xFF000000 );
    return( hostname( addr ) );

  } /* GetSessionOwnerName */
    
    
#else SIMPLELOOKUP
#undef NULL
#include <stdio.h>
/*
 * Host server lookup using host table file provided with server.
 * The file may entries of the form:

# this is a comment
<hostname> <hexpid>
   
 * Blank lines are also acceptable and there must be at least one
 * space or tab inbetween <hostname> and <hexpid>.  Note that
 * <hexpid> need only contain the logical host number for each host.
 */

#define MAX_HOST_NAME_LEN	32
FILE *HostTableFile;

MakeLowerCase( cp )
    register char *cp;
  {
    cp--;
    while( *++cp != 0 )
        if ( *cp >= 'A' && *cp <= 'Z' )
	    *cp -= 'A' - 'a';
	
  } /* MakeLowerCase */

InitHostTable()
/*
 * Open the host file.
 */
  {
    if ( (HostTableFile = fopen( HOST_TABLE_FILE, "r" )) == 0 )
      {
        if ( LDebug )
	    perror( HOST_TABLE_FILE );
	return( 0 );
      }
  } /* InitHostTable */

ProcessId GetServerPid( host )
    char *host;
/*
 * Look for the host in the HostTableFile.
 * If there is a match, then try to parse a hexpid
 * from the entry.  If any error occurs, return 0.
 */
  {
    static int TableInitialized = 0;
    extern char BlockBuffer[];
    char HostName[ MAX_HOST_NAME_LEN + 1 ];
    register char *hnp;
    register int hostnamelen;
    register char *cp;
    ProcessId serverpid;
    
    if ( !TableInitialized )
      {
        if ( !InitHostTable() )
	    return( 0 );		/* file not found */
	TableInitialized = 1;
      }
    
    if ( fseek( HostTableFile, 0, 0 ) == -1 )
        return( 0 );

    /* Make the host name pallatable */
    hnp = HostName;
    strncpy( hnp, host, MAX_HOST_NAME_LEN );
    hnp[ MAX_HOST_NAME_LEN ] = NULL;
    hostnamelen = strlen( hnp );
    MakeLowerCase( hnp );

    if ( LDebug )
        printf( "GetServerPid: %s\n", hnp );
    cp = BlockBuffer;
    while( fgets( cp, 256, HostTableFile ) != NULL )
      {
	if ( *cp == '#' || *cp == '\n' )
	    continue;	 	/* this line is a comment or blank */	
	cp[ hostnamelen ] = 0;
	MakeLowerCase( cp );
	if ( strcmp( cp, hnp ) == 0 )
	  {
	    /* The name and entry matched so try to read server pid */
	    cp += hostnamelen;
	    if ( sscanf( ++cp, "%x", &serverpid ) == 0 )
	      {
		/* Couldn't convert the entry */
	        if ( GDebug )
		    printf( "serverpid string invalid %s name is %s"
		     	    , cp, HostName );
	        return( 0 );
	      }

	    /* Coerce into a V server pid */
	    return( (serverpid&0xFF000000) + MAIN_SERVER_PID );
	  }
      } 
      
    return( 0 );	/* look up failed */
	    
  } /* GetServerPid */

char *GetSessionOwnerName( pid )
    ProcessId pid;
/*
 * Since we don't have a list of all
 * the hosts on the network, just return a constant
 */
   {
     return( "session" );
   } /* GetSessionOwnerName */

#endif SIMPLELOOKUP

