/*
 * The V UNIX server: a V kernel and V server simulator for VAX/UNIX
 * that provides a subset of UNIX system services to SUN workstations
 * running the V distributed kernel.
 * Copyright (c) 1982 David R. Cheriton, all rights reserved.
 *
 * Queue for synchronous IO on streams.
 */

#include <Venviron.h>
#include <Vio.h>
#include <Vioprotocol.h>
#include <server.h>
#include <debug.h>

WaitingIOEntry *WaitingIOEntries;

PrintEntry( entry )
    WaitingIOEntry *entry;
  {
    printf( "Entry = 0x%x\n", entry );
    printf( "	Pid = 0x%x\n", entry->pid );
    printf( "	IOF = 0x%x\n", entry->IOFunction );
    printf( "	link = 0x%x\n", entry->link );
    printf( "	reqcode = 0x%x\n", entry->req.requestcode );
    printf( "	fileid = 0x%x\n", entry->req.fileid );
    printf( "	blocknumber = %d\n", entry->req.blocknumber );
    printf( "	bufferptr = 0x%x\n", entry->req.bufferptr );
    printf( "	bytecount = %d\n", entry->req.bytecount );
  }

InitIOQueue ( )

    /*
     * Initialize the WaitingIOEntries to one entry.
     * This will speed up the IO queue handling.
     */
  {
    WaitingIOEntries = (WaitingIOEntry *)calloc( 1, sizeof(WaitingIOEntry) );
  } /* InitIOQueue */

SystemCode QueueIORequest( request, pid )
    IoRequest *request;
    ProcessId pid;
  /*
   * Put the IORequest in the WaitingIORequests queue
   * Set the IOFunction to the procedure that is to be called when
   * the IO queue is checked.
   */
  {
    extern WaitingIOEntry *WaitingIOEntries;
    extern SystemCode ReadInstance(), ReadAndForward(), WriteInstance();
    WaitingIOEntry *wio;
    register int i;
    register char *a,*b;

    if ( PDebug ) printf( " QueueIORequest for pid = 0x%x\n", pid );

    wio = WaitingIOEntries->link;
    while( wio != NULL && wio->pid != pid ) wio = wio->link;


    if ( wio != NULL ) 
      {
	return( NO_REPLY );    /* already in list */
      }

    if ( (wio = (WaitingIOEntry *)malloc( sizeof(WaitingIOEntry) )) == NULL )
      {
	request->bytecount = 0;
	return( NO_SERVER_RESOURCES );
      }
    
    /* Copy the message into the WaitingIOEntry */
    for ( i = 0, a = ((char *)(&(wio->req))), b = ((char *)request)
	  ; i < sizeof( Message ) ; i++) 
	  *a++ = *b++;
    wio->pid = pid;
    switch ( request->requestcode )
      {
	case READ_INSTANCE:
	    wio->IOFunction = ReadInstance;
	    break;
	case READ_AND_FORWARD:
	    wio->IOFunction = ReadAndForward;
	    break;
	case WRITESHORT_INSTANCE:
	case WRITE_INSTANCE:
	    wio->IOFunction = WriteInstance;
	    break;
	default:
	    if ( GDebug )
		printf( "QueueIORequest, illegal  requestcode = 0x%x\n"
		    , request->requestcode );
	    free( wio );
	    request->bytecount = 0;
	    return( INTERNAL_ERROR );
	    break;
      }
    
    wio->link = WaitingIOEntries->link;
    WaitingIOEntries->link = wio;
    return ( NO_REPLY );
  } /* QueueIORequest */
    
CheckIOQueue()
  /*
   * For every WaitingIOEntry we want to attempt to do the requested
   * operation.
   */
  {
    extern WaitingIOEntry *WaitingIOEntries;
    register WaitingIOEntry *prev, *ptr;
    SystemCode r;
    
    prev = WaitingIOEntries;
    while( (ptr = prev->link) != NULL ) 
      {
	if ( PDebug ) 
	  {
	    printf( "Check pid = 0x%x\n", ptr->pid );
	  }

	if ( (r = (ptr->IOFunction)(&(ptr->req), ptr->pid, 0)) != NO_REPLY )
	  {
	    if ( r != NOT_AWAITINGREPLY )
	      {
	        /* process the reply */
	    	ptr->req.requestcode = r;
	    	Reply( &(ptr->req), ptr->pid );
	      }

	    /* Unlink from WaitingIOEntries */
	    prev->link = ptr->link;
	    free( ptr );
	  }
	else 
	    prev = ptr;    /* traverse list */
	if ( PDebug ) printf( "	Reply = 0x%x \n", r );
      }

  } /* CheckIOQueue */
