/*
 * V-System Pipe Server
 * CopyRight (c) 1981 David Cheriton, all rights reserved.
 * transliterated from Verex and Zed. May 1983.
 */

#include "pipe.h"

Reminder( pid ) ProcessId pid;

    /* prompts pipe server to reclaim resources, every REMIND_TIME seconds */

  {
    Message msg;
    register IoRequest *req = (IoRequest *) msg;
    unsigned    i;

    i = 0;
    while(1)
      {
	register  PipeDesc *ptr, *prev;
        unsigned changes;

        changes = 0;
        Delay( REMIND_TIME, 0 );
	if( ++i > PIPE_MASK ) i = 0;

        for( prev = (PipeDesc *)&(Pipe_table[i]); (ptr=prev->link) != NULL; prev = ptr )
	  {
	    if( (ptr->readowner != 0) && !ValidPid(ptr->readowner) )
	      {
		ptr->readowner = 0;
		++changes;
	      }
	    if( (ptr->writeowner != 0) && !ValidPid(ptr->writeowner) )
              {
		ptr->writeowner = 0;
		++changes;
	      }	
	  }
	if( !changes ) continue;
        req->requestcode = RECLAIM;
        Send( msg, pid );
      }
  }
