/*
 * V-System Pipe Server
 * CopyRight (c) 1981 David Cheriton, all rights reserved.
 * transliterated from Verex and Zed. May 1983.
 */

#include "pipe.h"
extern Reminder();

SystemCode Create_pipe( req, pid )
    CreatePipeRequest *req; ProcessId pid;

    /* Create a pipe, consisting of two pipe ends. */

  {
    register CreateInstanceReply *reply = (CreateInstanceReply *) req;
    register PipeDesc  *pipe;
    register Buffer *buffer;
    register unsigned i;

    if( req->filemode != FCREATE ) return( INVALID_MODE );

    if( req->buffers < 2 || req->buffers > 10 ) req->buffers = 2;

    pipe = Alloc_pipe();
    pipe->readowner = req->readowner;
    pipe->writeowner = req->writeowner;
    pipe->lastblock = (0-1);
    
    for( i = 0; i < req->buffers; ++i )
      {
	if( (buffer = (Buffer *) malloc( sizeof(Buffer))) == NULL ) break;
	buffer->next = pipe->freebuffers;
	pipe->freebuffers = buffer;
      }
    if( Pipes++ == 0 ) /* Create a new reminder process for first pipe */
      {
        Reminder_process = Create( 0, Reminder, REMINDER_STACK );
	Ready( Reminder_process, 1 , Me );
      }
    reply->fileid = pipe->pipeid;
    return( Query_pipe(req, pid) );
  }
