/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANDFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Marvin Theimer,  5/83
 */


/*
 * Contains support routines for the PUP layer.
 */


#include "net.h"
#include "pup.h"


/*
 * Imported routines
 */

extern SystemCode WritePnet();
extern PktBuf AllocBuf();




/*
 * InitPupConnection:
 * Initializes data structures for an Pup connection.
 */

InitPupConnection(pTcb)
    PupTcbPtr pTcb;
  {
    pTcb->receiveBlocked = False;
    pTcb->netId = -1;
    pTcb->instState = True;
    InitSafeQueue(&(pTcb->readerQueue), pTcb->ringBufs);
    InitQueue(&(pTcb->readyQ));
    pTcb->waitFlag = False;
    pTcb->rcvId = 0;
    pTcb->bufferPtr = Null;
  }




/*
 * PupSendPnet:
 * Finds the appropriate
 * physical network address to send the PUP packet(s) to; and send(s)
 * it(them).
 */

SystemCode PupSendPnet(packet)
    PktBuf packet;
 {
    PupPktPtr pupPkt;
    PnetAddr dst;
    SystemCode status;

    pupPkt = (PupPktPtr) packet->dataptr;
    dst = pupPkt->dstPort.host;
    status = WritePnet(packet, dst, PupEtherType);
    return(status);
  }




/*
 * FindWhichPupSocket:
 * Finds the PUP instance referred to by the designated PUP socket.
 * Returns -1 if none found.
 */

int FindWhichPupSocket(socket)
    Bit32 socket;
  {
    int i, j = -1;
    PupTcbPtr p;

    for (i = NetInstHead; i != -1; i = NetInstTable[i].next)
	if (NetInstTable[i].prot == PUPtype)
	  {
	    p = (PupTcbPtr) NetInstTable[i].tcbId;
	    if (!p->instState)
		continue;	/* Connection is already closed. */
	    if (p->socket == 0)
	      {
		j = i;		/* Remember promiscuous connection. */
	      }
	    if (p->socket == socket)
		return(i);
	  }
    if (j != -1)
	return(j);
    else
	return(-1);
  }




/*
 * PupCrc:
 * Computes a checksum on a PUP packet.
 * Returns the result of the checksum computaion.
 */

PupCrc(buf, len)
    unsigned short *buf;
    int len;
  {
    register int l;
    unsigned long lcksm = 0;
    register unsigned short *ccksm = (unsigned short *) &lcksm;
    register unsigned short *cksm = (unsigned short *) &lcksm + 1;

    for (l = len/2; l>0;l--)	/* compute next cycle of checksum */
     {
	lcksm += *buf++;	/* add next short word */
	*cksm += *ccksm;	/* end-around carry */
	*ccksm = 0;		/* reset carry */
	lcksm <<= 1;		/* left-shift one bit */
	*cksm += *ccksm;	/* retrieve carry for rotate */
	*ccksm = 0;		/* reset carry */
      }
    if (*cksm == -1)		/* if result is same as default
				 * checksum, make it zero */
	*cksm = 0;
    return(*cksm);
  }




/*
 * PackPupPort:
 * Packs a PupPort record into a PackedPupPort record.
 */

PackPupPort(port, pacPort)
    PupPort *port;
    PackedPupPort *pacPort;
  {
    pacPort->net = port->net;
    pacPort->host = port->host;
    *((Bit32 *) &pacPort->fSocket) = port->socket;
  }




/*
 * UnpackPupPort:
 * Unpacks a PackedPupPort record into a PupPort record.
 */

UnpackPupPort(port, pacPort)
    PupPort *port;
    PackedPupPort *pacPort;
  {
    port->net = pacPort->net;
    port->host = pacPort->host;
    port->socket = *((Bit32 *) &pacPort->fSocket);
  }
