/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANDFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Marvin Theimer,  8/83
 *	First created.
 */

/*
 * Include file for multi-protocol definitions.
 */


#define NumProtocols 3		/* Number of protocols being supported. */
#define NumPnetProtocols 2	/* Number of protocols seen at the physical
				   network level. */

#define PupEtherType 01000	/* Ethernet packet type for PUP packets. */
#define IpEtherType 01001	/* Ethernet packet type for 
				   Internet packets. */


struct FuncBlock		/* Function table structure */
  {
    SystemCode (*CreateConnection) ();
    int (*NextTimeout) ();
  };

struct PnetBlock		/* Physical network protocol table record. */
  {
    unsigned prot;		/* Ethernet protocol type. */
    int active;			/* True if a network connection is active for
				   this protocol. */
    int (*rcv) ();		/* Receiving routine for this protocol. */
  };
