/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANDFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Marvin Theimer,  6/83
 */


/*
 * This module initializes all the internet server parameters which are 
 * tunable.
 */


#include "net.h"
#include "iptcp.h"


/*
 * General InternetServer parameters
 */

#define C_BufAllocNum 10	/* Number of buffers to allocate from free
				   memory when packet free list is empty. */
#define C_BufAllocMax 50	/* Maximum number of buffers on packet free
				   list before some are returned back to free
				   memory. */
#define C_MaxBufAllocNum 100	/* Maximum number of packet buffers allowed
				   in the whole system. */


/*
 * IP parameters
 */

#define C_ReassemblyTimeoutLen 1000
				/* Duration of timeout for reassembly of
				   packets in clicks. */


/*
 * TCP parameters
 */

#define C_RcvWindowSize 1000	/* Receive window size */ 
				/* 1000 */
#define C_RcvWindowCutoff 500	/* Reduction window size cutoff point */ 
				/* 500 */
/*
 * Timeout lengths in clicks.
 */
#define C_LenRetransTimeout 50	/* 50 */
#define C_LenTmeWaitTimeout MSL2 
#define C_LenAckTimeout 20
#define C_LenSndWndTimeout 500

#define C_MaxRetransTimeouts 10	/* Number of times to retransmit a packet
				   before giving up and closing the
				   connection. */
#define C_MSL 4000		/* Maximum Segment Lifetime in clicks. */
#define C_MSL2 8000		/* 2 * MSL */




InitParms()
  {
    /*
     * General Internetserver parameters
     */
    BufAllocNum = C_BufAllocNum;
    BufAllocMax = C_BufAllocMax;
    MaxBufAllocNum = C_MaxBufAllocNum;
    
    /*
     * IP parameters
     */
    ReassemblyTimeoutLen = C_ReassemblyTimeoutLen;
    
    /*
     * TCP parameters
     */
    RcvWindowSize = C_RcvWindowSize;
    RcvWindowCutoff = C_RcvWindowCutoff;
    LenRetransTimeout = C_LenRetransTimeout;
    LenTmeWaitTimeout = C_LenTmeWaitTimeout;
    LenAckTimeout = C_LenAckTimeout;
    LenSndWndTimeout = C_LenSndWndTimeout;
    MaxRetransTimeouts = C_MaxRetransTimeouts;
    MSL = C_MSL;
    MSL2 = C_MSL2;
  }
