/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANDFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Marvin Theimer,  8/83
 *	Merged old ip.h and tcp.h to form this file.
 *	Made defns. more modular to avoid conflict with other protocols.
 */


/*
 * Include file for Internet protocols.
 */




/********************
 *
 * General Definitions
 *
 ********************/


typedef struct IpSocketType	/* Internet host socket definition */
  {
    Bit16 port;
    Bit32 host;
  } IpSocket;




/********************
 *
 * IP Definitions
 *
 ********************/


/*
 * Constant definitions
 */

#define MaxIpPacketSize (MAXPBUFSIZE - 4)
				/* Maximum allowed size of IP packets. */

#define IpStackSize 2000	/* 4000 works */
				/* Size of stack for Ip connection processes.
				   */

#define CurrentInternetVersion	4


/*
 * Type definitions
 */

typedef unsigned long IpAddr;	/* IP address type. */

typedef struct IpTcbType	/* IP instance transmission control block. */
  {
    int netId;			/* Index of the corresponding network instance
				   descriptor record. */
    Boolean instState;		/* State of connection wrt to open/closed. */
    Boolean receiveBlocked;	/* True if connection process is receive
				   blocked (and hence can't dequeue
				   incoming network packets). */
    RingQueue readerQueue;	/* Packet queue used to queue incoming
				   packets from the network. */
    RingBufRec ringBufs[MAX_RING_BUFS];
				/* Ring buffer pool used in conjunction with
				   the readerQueue to provide synchronization
				   between competing processes. */
    char prot;			/* IP protocol id */
    Queue readyQ;		/* Queue of packets waiting to be received. */
    Boolean waitFlag;		/* Flag to signal if a read is 
				   outstanding. */
    ProcessId rcvId;		/* Process id of reader. */
    char *bufferPtr;		/* Address of user's buffer. */
  } IpTcbRec, *IpTcbPtr;

typedef struct iphdr		/* IP packet header structure.
				   See Internet handbook for defns.
				   of the various fields. */
{
    unsigned version: 4;
    unsigned ihl: 4;		/* Internet header length */
    unsigned tos: 8;		/* Type of service */
    Bit16 tl;			/* Total length */
    Bit16 id;			/* Identifier */
    unsigned reserved: 1;
    unsigned mayFragment: 1;
    unsigned moreFragments: 1;
    unsigned fo: 13;		/* Fragment offset */
    Bit8 ttl;			/* Time to live */
    Bit8 prot;
    Bit16 checksum;
    IpAddr srcAdr;
    IpAddr dstAdr;
}
    *IpHdrPtr;

typedef struct HoleDescrStruct	/* Descriptor for an IP fragment hole.
				   These are stored in the actual
				   holes themselves. */
  {
    short first,last;
    struct HoleDescrStruct *next;
  } *HoleDescrPtr;


/*
 * Variable declarations
 */

Queue ReassemblyList;	/* Header for the list of packets
				   currently being reassembled. */

IpAddr LocalIpHost; 		/* Internet address of local host. */


/*
 * Tunable variables - see parms.c for defns.
 */

int ReassemblyTimeoutLen;


/*
 * Macro definitions
 */

#define FragmentedPacket(iphdr) ((iphdr->mayFragment) ||  \
				(iphdr->moreFragments) || \
				(iphdr->fo != 0))
				/* Returns whether the packet represents
				   a fragment or not. */

#define SamePacket(p1,p2) ((p1->srcAdr == p2->srcAdr) && \
			(p1->dstAdr == p2->dstAdr) && \
			(p1->id == p2->id) && \
			(p1->prot == p2->prot))
				/* Returns whether p1 and p2 are parts of
				   the same IP packet. */

#define IpDataStart(pkt) (((char *)pkt->dataptr) + \
			(((IpHdrPtr)pkt->dataptr)->ihl << 2))
				/* Start of the IP packet's data. */

#define HoleHdr(pkt) pkt->unspecified[0]
				/* Used to store the header of the
				   fragment holes list for a packet
				   being reassembled. */
#define IpTimeoutVal(pkt) pkt->unspecified[1]
				/* Stores ptr to the timeout record
				   associated with a packet being
				   reassembled. */




/********************
 *
 * TCP Definitions
 *
 ********************/


/*
 * Various constants
 */

#define MinPacketDataLength 128	/* Minimum size of Tcp data packet
				   allowed. */
#define MaxPacketDataLength (MAXPBUFSIZE - 50)
				/* Maximum size of Tcp data packet
				   allowed.  Must be between 
				   MinPacketDataLength and 
				   MAXPBUFSIZE - 46 . */

#define TcpStackSize 4000	/* 5000 works */
				/* Size of stack to use for Tcp connection
				   processes.  This size must take into 
				   account the fact that the tcb is allocated
				   on the process stack. */

#define StandardByteDataOffset 20
				/* Standard offset of the data in bytes in 
				   a TCP packet (i.e. no options field). */

#define	TCPprot	6		/* Transmission Control Protocol type id */

/*
 * Option code byte values for Tcp options.
 */
#define EndOptionList (Bit8)00
#define NopOption (Bit8)01
#define MaxSegSizeOption (Bit8)02

/*
 * Tcp states.
 */
#define Closed 0
#define Listen 1
#define SynSent 2
#define SynRcvd 3
#define Estab 4
#define FinWait1 5
#define FinWait2 6
#define CloseWait 7
#define LastAck 8
#define Closing 9
#define TimeWait 10

/*
 * Queue enumeration type.
 */
#define NumTcpQueues 4		/* Number of queues for a Tcp connection. */

#define SendQueue 0		/* Queue used to store user's data to be
				   sent. */
#define RetransQueue 1		/* Queue used to store user's data waiting
				   to be retransmitted or acknowledged. */
#define SegQueue 2		/* Queue used to store data that has been
				   sent by the remote host but not yet
				   received by the user. */
#define SaveQueue 3		/* Queue used to store packets whose 
				   sequence numbers are beyond the rcvNxt
				   value for the connection. */

/*
 * Timeout enumeration type.
 */
#define NumTcpTimeouts 4	/* Number of Tcp timeout types. */

#define RetransTimeout 0	/* Retransmission timeout. */
#define TmeWaitTimeout 1	/* Timeout for TimeWait state. */
#define AckTimeout 2		/* Time allowed before an Ack must be
				   sent. */
#define SndWndTimeout 3		/* Retransmission timeout for periodically
				   querying the remote host in 
				   too small window size situations. */

/*
 * TCP connection state wrt to release and closing
 */
#define TCP_CONN_RELEASED 1	/* Selects release bit */
#define TCP_CONN_CLOSED 2	/* Selects closed bit */


/*
 * Record formats
 */

typedef struct TcbType		/* Transmission control block.  This
				   record keeps track of all state
				   information for a connection. */
  {
    Boolean receiveBlocked;	/* True if connection process is receive
				   blocked (and hence can't dequeue
				   incoming network packets). */
    RingQueue readerQueue;	/* Packet queue used to queue incoming
				   packets from the network. */
    RingBufRec ringBufs[MAX_RING_BUFS];
				/* Ring buffer pool used in conjunction with
				   the readerQueue to provide synchronization
				   between competing processes. */
    int netId;			/* Index of associated network 
				   instance descriptor. */
    unsigned instState;		/* State of connection instance wrt to release
				   by its owner and state of Tcp connection.
				   bit 1: released;
				   bit 2: closed. */
    Process_id rcvId;		/* Process id of user Receive call
				   process. */
    Process_id wtSignalId;	/* Process id of user WaitSignal call
				   process. */
    Bit16 localPort;		/* Local port associated with this
				   connection. */
    IpSocket   foreignSocket;	/* Foreign socket associated with this
				   connection. */
    int     state;		/* Current state of Tcp finite state
				   machine. */
    Boolean passiveOpen;	/* Indicates whether original Open was
				   passive. */
    IpSocket   originalForeignSocket;
				/* Foreign socket this connection was
				   opened with.  Used to restore a
				   connection to passive Listen state. */
    Boolean active;		/* Indicates whether connection is
				   currently active. */
    int     prc;		/* Precedence of connection. */
    Boolean higherPrcAllowed;	/* Indicates whether remote host may
				   specify a higher precedence for the
				   connection. */
    int     security;		/* Security of connection. */
    Boolean waitSignal;		/* Indicates if a WaitSignal call is
				   outstanding. */
    int maxPacketDataLength;	/* Maximum allowed segment size accepted
				   by foreign host. */
    int     rcvByteCnt;		/* Size of user's receive buffer. */
    char *rcvQ;			/* Ptr to user's Receive call buffer. 
				   Null if no Receive call is outstanding.
				*/
    PktBuf lastReadBuf;		/* Ptr to last buffer the user has already
				   received.  Used for handling duplicate
				   read requests. */
    int     segQBytesAvail;	/* Number of data bytes available in
				   segment Q. */
    Queue q[NumTcpQueues];	/* Send, Retrans, Seg, and Save queues. */
    int timers[NumTcpTimeouts];
    Bit32 sndUna;		/* send unacknowledged */
    Bit32 sndNxt;		/* send next */
    Bit16 sndWnd;		/* send window */
    Bit32 sndUp;		/* send urgent pointer */
    Bit32 sndWl1;		/* segment sequence number used for last
				   window update. */
    Bit32 sndWl2;		/* segment acknowledgement number used for
				   last window update. */
    Boolean sndUrgBit;		/* Signals that data is urgent. */
    Bit32 iss;			/* initial send sequence number. */
    Bit32 rcvNxt;		/* receive next */
    Bit16 rcvWnd;		/* receive window */
    Bit16 delRcvWnd;		/* reduction in receive window size */
    Boolean rcvUrgFlag;		/* signals that urgent data is pending */
    Bit32 rcvUp;		/* receive urgent pointer */
    Bit32 irs;			/* receive initial sequence number */
    int numRetransTimeouts;	/* number of retransmissions */
    int numOutOfOrderPkts;	/* number of out of order pkts arrived */
  } *TcpTcbPtr;

typedef struct CurPktType	/* Information associated with incoming
				   segments. */
  {
    Bit32 foreignHost;		/* Foreign host which sent the 
				   segment. */
    Bit16 foreignPort;		/* Foreign port which sent the
				   segment. */
    PktBuf segAdr;		/* Ptr to segment buffer. */
    int	 segLen;		/* segment length */
    int     segPrc;		/* segment precedence */
    int     segSecurity;	/* segment security */
    int     segDataOffset;	/* segment data offset in bytes */
  } CurPktRec, *CurPktPtr;

struct TcpHeader		/* Tcp header format.  See Internet
				   handbook for defns. of fields. */
  {
    Bit16 sourcePort;
    Bit16 destinationPort;
    Bit32 sequenceNumber;
    Bit32 acknowledgementNumber;
    unsigned    dataOffset:     4;
    unsigned    reserved:     6;
    unsigned    urg:     1;
    unsigned    ack:     1;
    unsigned    psh:     1;
    unsigned    rst:     1;
    unsigned    syn:     1;
    unsigned    fin:     1;
    Bit16 window;
    Bit16 checkSum;
    Bit16 urgentPointer;
  };

typedef struct TcpBufType	/* Buffer type for Tcp packets. */
  {
    struct TcpHeader    hdr;	/* Tcp packet header. */
    Bit8 data[MaxPacketDataLength];
				/* Tcp packet data. */
  } *TcpPktPtr;


/*
 * Tuning variables - see parms.c for defns.
 */

int RcvWindowSize, RcvWindowCutoff;
int LenRetransTimeout, LenTmeWaitTimeout, LenAckTimeout, LenSndWndTimeout;
int MaxRetransTimeouts;
int MSL, MSL2;


/*
 * Macro declarations
 */

#define DStart(packet) ((((TcpPktPtr) (packet->dataptr)) -> hdr.dataOffset) << 2)
				/* Ptr to start of data portion of a
				   TCP segment. */
#define DLength(packet) (packet->length - DStart(packet))
				/* Length of data portion of a TCP
				   segment. */

#define TcpPkt(packet) ((TcpPktPtr) (packet->dataptr))
