/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Routines to register/unregister the local team server with the host server.
 *
 * Marvin Theimer, 6/83.
 */


#include <Vio.h>
#include <Vteams.h>
#include <Vhosts.h>


SystemCode RegisterTeamServer(name, availability)
    char *name;
    int availability;
  {
    ProcessId teamServer, hostServer;
    Message msg;
    RegisterHostRequest *reqMsg = (RegisterHostRequest *) msg;

    /* Get the pid of the local team server. */
    teamServer = GetPid(TEAM_SERVER, LOCAL_PID);
    if (teamServer == 0)
      {
	return(SERVER_NOT_RESPONDING);
      }

    /* Locate the host server. */
    hostServer = GetPid(HOST_SERVER, ANY_PID);
    if (hostServer == 0)
      {
	return(SERVER_NOT_RESPONDING);
      }

    /* Register the team server's pid with the host server. */
    reqMsg->requestcode = RegisterHost;
    reqMsg->requestType = Register;
    reqMsg->regPid = teamServer;
    reqMsg->availability = availability;
    reqMsg->bufferptr = name;
    reqMsg->bytecount = strlen(name) + 1;
    Send(msg, hostServer);
    return(reqMsg->requestcode);
  }




SystemCode UnregisterTeamServer()
  {
    ProcessId teamServer, hostServer;
    Message msg;
    RegisterHostRequest *reqMsg = (RegisterHostRequest *) msg;
    char name[1];		/* Dummy msg segment. */

    /* Get the pid of the local team server. */
    teamServer = GetPid(TEAM_SERVER, LOCAL_PID);
    if (teamServer == 0)
      {
	return(SERVER_NOT_RESPONDING);
      }

    /* Locate the host server. */
    hostServer = GetPid(HOST_SERVER, ANY_PID);
    if (hostServer == 0)
      {
	return(SERVER_NOT_RESPONDING);
      }

    /* Unregister the team server's pid with the host server. */
    reqMsg->requestcode = RegisterHost;
    reqMsg->requestType = Unregister;
    reqMsg->regPid = teamServer;
    reqMsg->bufferptr = name;	/* Must specify an actual segment to keep the
				   kernel happy. */
    reqMsg->bytecount = 1;
    Send(msg, hostServer);
    return(reqMsg->requestcode);
  }
