/*
 * Marvin Theimer, 6/83
 *
 * Routines to manipulate a database on V-system hosts.
 *
 * Currently uses hard-wired tables.
 */


#define ENET3MEG
#include <Vethernet.h>


typedef struct
  {
    NetAddress addr;
    char *name;
  } HostEntry;


HostEntry HostTable[] =
  {
    28, "sun-mj402",
    2, "sun-mj416",
    27, "sun-mj416a",
    26, "sun-mj420",
    29, "sun-mj424",
    55, "sun-mj426",
    38, "sun-mj450",
    7, "sun-mj460",
    18, "sun-cisa",
    33, "sun-cisb",
    0,0
  };


extern char *strsave();





/*
 * SetHostName:
 * Returns a ptr to a string containing the host name for the host on 
 * which the designated pid resides.
 */

char *SetHostName(regPid)
    ProcessId regPid;
  {
    int i;
    NetAddress addr;

    addr = (0xff000000 & regPid) >> 24;
    for (i = 0; HostTable[i].name != NULL; i++)
      {
	if (HostTable[i].addr == addr)
	  {
	    return(strsave(HostTable[i].name));
	  }
      }
    return(strsave("Mystery host"));
  }
