/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANDFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * V Host Server
 *
 * Marvin Theimer, 6/83
 *
 * This server registers hosts currently running the V-system.
 * Registration is done on a voluntary basis by each host.
 */


#include <Venviron.h>
#include <Vprocess.h>
#include <Vteams.h>
#include <Vioprotocol.h>
#include <Vhosts.h>


#define FALSE 0
#define TRUE 1

#define MaxEntries 32


typedef struct
  {
    int inUse;
    ProcessId regPid;		/* Registered pid. */
    char *name;			/* String name associated with pid. */
    char *hostName;		/* Host name. */
    int availability;		/* Status of host wrt to remote task
				   execution. */
  } RegEntry;


RegEntry Registry[MaxEntries];


extern char *malloc();


SystemCode RegisterHostInstance();
SystemCode ReturnHostsInstance();
char *SetHostName();
SystemCode InitializeEntry();


/*
 * InitHostServer:
 * Starts up the host server if it doesn't already exist.
 */

InitHostServer(newProcess)
    int newProcess;		/* True if HostServer should as a separate
				   process. */
  {
    ProcessId hostServerPid;
    int HostServer();

    if (ValidPid(GetPid(HOST_SERVER, ANY_PID)))
	return;

    if (newProcess)
      {
	hostServerPid = Create(0, HostServer, 4000);
	if (hostServerPid == 0)
	  {
	    printf("ERROR - Failed to create host server process.\n");
	    exit();
	  }
	if (!Ready(hostServerPid, 0))
	  {
	    printf("ERROR - Failed to ready host server process.\n");
	    exit();
	  }
      }
    else
	hostServerPid = GetPid(ACTIVE_PROCESS, ANY_PID);

    SetPid(HOST_SERVER, hostServerPid, ANY_PID);

    if (!newProcess)
	HostServer();
  }


/*
 * HostServer:
 * Top level of the host server.
 */

HostServer()
  {
    Message msg;
    RegisterHostRequest *reqMsg = (RegisterHostRequest *) msg;
    ProcessId reqPid;
    int i;

    /* Initialize the server. */
    for (i = 0; i < MaxEntries; i++)
      {
	Registry[i].inUse = 0;
      }
    
    /* Loop on requests for service. */
    while (TRUE)
      {
	reqPid = Receive(reqMsg);
	switch (reqMsg->requestcode)
	  {
	    case RegisterHost:
	        reqMsg->requestcode = RegisterHostInstance(reqMsg, reqPid);
		break;
	    case ReturnHosts:
	        reqMsg->requestcode = ReturnHostsInstance(reqMsg, reqPid);
		break;
	    default:
	        reqMsg->requestcode = REQUEST_NOT_SUPPORTED;
		break;
	  }
	if (reqMsg->requestcode != NO_REPLY)
	  {
	    Reply(reqMsg, reqPid);
	  }
      }
  }




/*
 * RegisterHostInstance:
 * Registers/unregisters a host.
 */

SystemCode RegisterHostInstance(reqMsg, reqPid)
    RegisterHostRequest *reqMsg;
    ProcessId reqPid;
  {
    int i;
    SystemCode status;

    if (reqMsg->requestType == Register)
      {
        /* Check if this is a re-registration. */
        for (i = 0; i < MaxEntries; i++)
	  {
	    if (Registry[i].inUse  && (Registry[i].regPid == reqMsg->regPid))
	      {
	        status = InitializeEntry(i, reqMsg, reqPid);
		return(status);
	      }
	  }

	/* This was not a re-registration.  Create a new entry. */
        for (i = 0; i < MaxEntries; i++)
          {
	    if (!Registry[i].inUse)
	      {
	        status = InitializeEntry(i, reqMsg, reqPid);
		return(status);
	      }
          }
        return(NO_SERVER_RESOURCES);
      }
    else if (reqMsg->requestType == Unregister)
      {
        for (i = 0; i < MaxEntries; i++)
	  {
	    if (Registry[i].inUse && (Registry[i].regPid == reqMsg->regPid))
	      {
		Registry[i].inUse = FALSE;
		free(Registry[i].name);
		free(Registry[i].hostName);
		return(OK);
	      }
	  }
	return(BAD_ARGS);
      }
    else
        return(BAD_ARGS);
  }




/*
 * ReturnHostsInstance:
 * Returns information on the specified hosts.
 */

SystemCode ReturnHostsInstance(reqMsg, reqPid)
    ReturnHostsRequest *reqMsg;
    ProcessId reqPid;
  {
    ReturnHostsReply *repMsg = (ReturnHostsReply *) reqMsg;
    int i, n = 0;
    ProcessId buffer[MaxEntries];
    char *nameBuf = (char *) buffer;
				/* Use the same buffer for two different
				   uses, depending on the request type. */
    char *ptr;
    SystemCode status;
    int len = 0, len1;

    if (reqMsg->requestType == AllEntries)
      {
        for (i = 0; i < MaxEntries; i++)
          {
	    if (Registry[i].inUse)
	      {
	        buffer[n] = Registry[i].regPid;
	        n++;
		len += sizeof(ProcessId);
		if (len > reqMsg->bytecount)
		    return(BAD_BUFFER);
	      }
          }
        repMsg->numEntries = n;
        status = MoveTo(reqPid, reqMsg->bufferptr, buffer, len);
        return(status);
      }
    else if (reqMsg->requestType == SpecificEntry)
      {
	for (i = 0; i < MaxEntries; i++)
	  {
	    if (Registry[i].inUse && (Registry[i].regPid == reqMsg->regPid))
	      {
	        len = strlen(Registry[i].name);
		len1 = len + strlen(Registry[i].hostName) + 2;
		if (len1 > reqMsg->bytecount)
		    return(BAD_BUFFER);
		repMsg->numEntries = 1;
		repMsg->availability = Registry[i].availability;
		strcpy(nameBuf, Registry[i].name);
		ptr = nameBuf + len + 1;
		strcpy(ptr, Registry[i].hostName);
		status = MoveTo(reqPid, reqMsg->bufferptr, nameBuf, len1);
		return(status);
	      }
	  }
	return(BAD_ARGS);
      }
    else
        return(BAD_ARGS);
  }




/*
 * InitializeEntry:
 * Initialize an entry from reqMsg.
 */

SystemCode InitializeEntry(i, reqMsg, reqPid)
    int i;
    RegisterHostRequest *reqMsg;
    ProcessId reqPid;
  {
    SystemCode status;

    Registry[i].inUse = TRUE;
    Registry[i].regPid = reqMsg->regPid;
    Registry[i].availability = reqMsg->availability;
    Registry[i].name = malloc(reqMsg->bytecount);
    status = MoveFrom(reqPid, Registry[i].name, reqMsg->bufferptr,
	    reqMsg->bytecount);
		    /* Note: assumes bytecount includes the \0
		       at the end. */
    if (status != OK)
      {
	Registry[i].inUse = FALSE;
	free(Registry[i].name);
	return(status);
      }
    Registry[i].hostName = SetHostName(Registry[i].regPid);
    return(OK);
  }
