/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1983			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/*
 * usemouse.c: procedures to use the mouse facilities of the vgts	
 *
 * Kenneth Brooks March 1983
 * Integrated with VGTS by Bill Nowicki April 1, 1983
 */

#include <Vioprotocol.h>
#include "Vgts.h"


/* 
 * GetGraphicsEvent: Get a click or transition, depending on the mode of	
 * the VGT.  Invalid if the VGT has neither ReportTransition nor	
 * ReportClick set.  Returns the value of the buttons, or -1 in case of	
 * error.  In this and subsequent procedures, px, py, or pbuttons may	
 * be NULL if that information is not wanted.				
 */

int GetGraphicsEvent(fad, px, py, pbuttons)
  register File *fad;
  short *px, *py, *pbuttons;
{
  EventReq msg;
 
  msg.requestcode = EventRequest;
  msg.eventcode = ReportClick + ReportTransition;
  msg.fileid = fad->fileid;
  
  Send(&msg, fad->fileserver);

  fad->lastexception = msg.requestcode;  /* now the reply code */

  if (fad->lastexception == OK) 
    {
      if (px) *px = msg.x;
      if (py) *py = msg.y;
      if (pbuttons) *pbuttons = msg.buttons;
      return(msg.buttons);
    }
   return(-1);
  }

int GetMouseEvent(fad, px, py, pbuttons)
  {
  	/*
	 * Backward compatibility!
	 */
   return( GetGraphicsEvent(fad, px, py, pbuttons) );
  }


/* 
 * GetGraphicsStatus: Get the current position (world coordinates) and
 * button status of the mouse, if it is in this VGT.  Returns buttons
 * value if it succeeds, -1 if it fails (which usually means that the
 * mouse is currently outside this VGT.				
 */

int GetGraphicsStatus(fad, px, py, pbuttons)
  register File *fad;
  short *px, *py, *pbuttons;
{
  EventReq msg;
  
  msg.requestcode = EventRequest;
  msg.eventcode = ReportMotion;
  msg.fileid = fad->fileid;
  
  Send(&msg, fad->fileserver);

  fad->lastexception = msg.requestcode;  /* now the reply code */

  if (fad->lastexception == OK) 
    {
        if (px) *px = msg.x;
        if (py) *py = msg.y;
        if (pbuttons) *pbuttons = msg.buttons;
        return(msg.buttons);
    }
  else return(-1);
  }

GetMouseStatus(fad, px, py, pbuttons)
  {
  	/*
	 * Backward compatibility!
	 */
   return( GetGraphicsStatus(fad, px, py, pbuttons) );
  }


/*
 * GetEvent: Get the next event, be it a keystroke or a click
 * or transition (according to mode).  Returns -1 on error, 0 on mouse
 * event, or number of characters returned on a keyboard event.	
 * On a mouse event, px, py, and pbuttons are used to return the 
 * information, provided they are not NULL.  On a keyboard event, cbuf,
 * which must never be NULL, is used to return the characters.  cbuf
 * should refer to an array large enough to hold 20 characters.	
 */

int GetEvent(fad, px, py, pbuttons, cbuf)
  register File *fad;
  short *px, *py, *pbuttons;
  char cbuf[IO_MSG_BUFFER];
{
  EventReq msg;

  msg.requestcode = EventRequest;
  msg.eventcode = ReportClick + ReportTransition + ReportCharacter;
  msg.fileid = fad->fileid;
  
  Send(&msg, fad->fileserver);

  fad->lastexception = msg.requestcode;  /* now the reply code */

  if (fad->lastexception != OK) return(-1);
  else if (msg.eventcode == ReportCharacter) 
    {
      register IoReply *I = (IoReply *) &msg;
      register int j;

      for (j=0; j < I->bytecount; j++)  cbuf[j] = I->shortbuffer[j];
      return(I->bytecount);
    }
  else 
    {  /* mouse event */
      if (px) *px = msg.x;
      if (py) *py = msg.y;
      if (pbuttons) *pbuttons = msg.buttons;
      return(0);
    }
  }


RedrawPad(fad)  
    register File *fad;
 {
    IoRequest msg;

    msg.requestcode = (short)RedrawRequest;
    msg.fileid = fad->fileid;
    return(Send(&msg, fad->fileserver));
  }
  

