/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/*
 * unixtty.c.c - save and restore the state of the Unix tty device
 *
 * Bill Nowicki September 1982
 */

# include <sgtty.h>
# include <signal.h>
# include <stdio.h>
# include "Vgts.h"

static struct sgttyb save_tty;		/* saved structure */


GetTTY()		/* Get bits in tty structure */
			/* called at the begining to get into raw mode */
{	
 struct sgttyb tty;
 if (isatty(0))
  {
     gtty( 0, &tty );			/* save two copies */
     gtty( 0, &save_tty );
     tty.sg_flags |= RAW; 			/* set our special mode */
     tty.sg_flags &= ~ECHO; 
     stty( 0, &tty );
  } 
 else SetMode(CR_Input);
 fflush(stdout);
}


ResetTTY( )			/* Reset bits in tty structure */
				/* to what they were when we were invoked */
{	
  if (isatty(0))
    {
      stty( 0, &save_tty );
      SetMode(ReportEscSeq);
    }
  else SetMode(CR_Input+LF_Output+Echo+LineBuffer);
  fflush(stdout);
}

