/*
 * Team root function, called when program starts execution.
 *
 */
#include "../include/Vteams.h"
#include "../include/Vprocess.h"
#include "../include/Vio.h"
#include "../include/Vnaming.h"

extern File *OpenFile();
extern char *malloc();
extern RereadMsg();
extern char _end;

Process_id Kernel_Process_Pid;
Message _RootMsg;	/* Store original reply message from creator */
RootMessage *RootMsg = (RootMessage *) _RootMsg;
PerProcessArea *PerProcess = NULL;

TeamRoot( argc, argv )
    int argc;
    char *argv[];
    /*
     * The team root is the initial function executed by the root process
     * of a V team. It reads the initial reply message, sets up the standard
     * input and output, and calls main.
     */ 
  {
    extern ProcessId TeamCreator, Kernel_Process_Pid;
    extern RootMessage *RootMsg;
    Processor_state state;

    RereadMsg( RootMsg, 0 ); /* Read reply from message buffer */
    Kernel_Process_Pid = RootMsg->kernelpid;
    TeamCreator = Creator( 0 );

    /* Set up per-process area for this team's root process */
    PerProcess = (PerProcessArea *) &_end;

    /* Set stack size -- assumes stack from _end to end of team space */
    PerProcess->stackSize = ((char *) GetTeamSize(0)) - &_end;

    /* Setup open files */
    stdin = OpenFile( RootMsg->stdinserver, RootMsg->stdinfile, FREAD 
	+ (RootMsg->rootflags&RELEASE_INPUT ? FRELEASE_ON_CLOSE : 0), NULL );
    stdout = OpenFile( RootMsg->stdoutserver, RootMsg->stdoutfile,
	(RootMsg->rootflags&STDOUT_APPEND ? FAPPEND : FCREATE)
	+ (RootMsg->rootflags&RELEASE_OUTPUT ? FRELEASE_ON_CLOSE : 0), NULL );

    /* Set stderr to same file as stdout if same instance is specified */
    if( RootMsg->stdoutserver == RootMsg->stderrserver &&
	    RootMsg->stdoutfile == RootMsg->stderrfile )
      {
	stderr = stdout;
      }
    else
      {
	stderr = OpenFile( RootMsg->stderrserver, RootMsg->stderrfile,
	    (RootMsg->rootflags&STDERR_APPEND ? FAPPEND : FCREATE) +
	    (RootMsg->rootflags&RELEASE_ERR ? FRELEASE_ON_CLOSE : 0), NULL );
      }

    /* Setup default server and context */
    if (RootMsg->nameserver != 0)
      {
	PerProcess->nameserver = RootMsg->nameserver;
	PerProcess->contextid = RootMsg->contextid;
      }
    else
      {
	PerProcess->nameserver = GetPid(STORAGE_SERVER, ANY_PID);
	PerProcess->contextid = PUBLIC_CONTEXT;
      }

    /* Set up PerProcess pointer */
    ReadProcessState(0, &state);
    state.perProcessLoc = (Unspec **) &PerProcess;
    state.perProcess = (Unspec *) PerProcess;
    WriteProcessState(0, &state);

    main( argc, argv );
    exit( 0 );		/* Terminate the team on return from main */
  }


