/*
 * V Kernel - Copyright (c) 1982 by David Cheriton, Tim Mann
 * (Transliterated from Zed and Verex Kernel)
 *
 *  This file assembles into the library routines used to call
 *    kernel operations.  
 *
 */

/* Macro which expands into the calling sequence for a 3-argument
 *  kernel trap.  Moves args into registers d1, a0, a1, trap #
 *  to d0, and executes a trap #0.
 */

#define kernelop( name, n )					\
								\
int name();							\
asm("	.text");						\
asm("	.globl	name");						\
asm("name:");							\
asm("	moveml	sp@(4),#/0302");	/* 3 args to d1,a0, a1*/\
asm("	trap	#n");			/* Trap to system */	\
asm("	rts" );

/* On exit, d0 contains the value returned by the trap.  d1, a0, and a1	*
 * are destroyed by the argument passing but this is in accord with the *
 * 68000 C calling conventions.						*/

/* Macro used for 4-argment kernel operations.  Similar to the above,
 *  but an extra register is needed, so a2 is saved on the stack and then
 *  used.
 */

#define kernelop4( name, n )					\
								\
int name();							\
asm("	.text");						\
asm("	.globl	name");						\
asm("name:");							\
asm("	movl	a2,sp@-");					\
asm("	moveml	sp@(8),#/0702");	/* 4 args to d1,a0-a2 */\
asm("	trap	#n");			/* Trap to system */	\
asm("	movl	sp@+,a2");					\
asm("	rts" );

/* Macro used for 5-argument kernel operations.  Similar to the above,
 *  but an extra register is needed, so a2 is saved on the stack and then
 *  used.
 */

#define kernelop5( name, n )					\
								\
int name();							\
asm("	.text");						\
asm("	.globl	name");						\
asm("name:");							\
asm("	movl	a2,sp@-");					\
asm("	movl	a3,sp@-");					\
asm("	moveml	sp@(12),#/0f02");	/* 5 args to d1,a0-a3 */\
asm("	trap	#n");			/* Trap to system */	\
asm("	movl	sp@+,a3");					\
asm("	movl	sp@+,a2");					\
asm("	rts" );

/* Kernel trap operations. Must be consistent with the kernel trap table */

kernelop( Forward, 5 )
kernelop( GetPid, 6 )
kernelop4( MoveFrom, 7 )
kernelop4( MoveTo, 8 )
kernelop( ReceiveSpecific, 9 )
kernelop( ReceiveWithSegment, 10 )
kernelop5( ReplyWithSegment, 11 )
kernelop( RereadMsg, 12 )
kernelop( Send, 13 )
