/*
 * Function-call interface to GET_CONTEXT_NAME message.  Gets the name
 * of the contextid associated with the contextid and serverpid.
 *
 * Returns a null terminated string in name.
 * namelength is passed in as the maximum length of the name and
 * returned as the actual length.
 * serverpid and contextid are modified upon the return to indicate
 * what context the name is valid in.
 *
 */

#include <Vnaming.h>

SystemCode GetContextName(name, namelength, serverpid, contextid, nameserver)
    char *name;
    unsigned *namelength;
    ProcessId *serverpid;
    ContextId *contextid;
    ProcessId nameserver;
  {
    Message msg;
    register ContextRequest *request = (ContextRequest *) msg;
#define reply ((ContextReply *) request)

    request->requestcode = GET_CONTEXT_NAME;
    request->nameindex = 0;
    request->serverpid = *serverpid;
    request->contextid = *contextid;
    request->entrytype = 0;
    request->instanceid = 0;
    request->otherinfo = 0;
    request->namecontextid = 0;
    request->nameptr = name;
    request->namelength = *namelength - 1;

    Send( request, nameserver );

    if( reply->replycode != OK )
      {
	*name = NULL;	/* mark string as zero length */
        return (reply->replycode);
      }

    /* else terminate the string */
    name[ *namelength = reply->namelength ] = NULL;
    *serverpid = reply->serverpid;
    *contextid = reply->contextid;
    return( reply->replycode );

#undef reply

  } /* GetContextName */
