/*
 * getcontextid.c
 *
 * Function-call interface to GET_CONTEXT_ID message.  Interprets the 
 *   given name in the current context and returns a corresponding
 *   serverpid/contextid pair.
 */
#include "../include/Vioprotocol.h"
#include "../include/Vnaming.h"

SystemCode GetContextId(name, serverpid, contextid)
    char *name;
    ProcessId *serverpid;
    ContextId *contextid;
  {
    Message msg;
    register ContextRequest *req = (ContextRequest*) msg;
    register ContextReply *reply = (ContextReply *) msg;
    ProcessId pid;

    req->requestcode = GET_CONTEXT_ID;
    req->nameindex = 0;
    req->nameptr = name;
    req->namelength = strlen( name );

    /* Interpret the given name in the current context */
    Send(req, DirectToCurrentContext(req));

    if (reply->replycode != OK) return (reply->replycode);

    /* Return serverpid and contextid */
    *serverpid = reply->serverpid;
    *contextid = reply->contextid;

    return (OK);
  }
