/*
 * directcurctx.c
 * DirectToCurrentContext directs a request to the current context, or to
 *   the local name server if it begins with a square bracket ('[').
 *   The function returns the pid to which the request should be sent,
 *   and puts the proper context id in the contextid field of the message.
 *   This is written as a function to avoid duplicating the code that
 *   knows about square brackets all over the place.
 *
 * Tim Mann 8-26-83
 */

#include "Vnaming.h"

ProcessId DirectToCurrentContext(request)
    register NameRequest *request;
  {
    /* The name is directed to the current context if it
     *  does not begin with a '['; else it goes to the local
     *  name server */
    if (request->nameptr[request->nameindex] == '[')
      {
        request->namecontextid = DEFAULT_CONTEXT;
	return( GetPid(NAME_SERVER, LOCAL_PID) );
      }
    else
      {
	request->namecontextid = PerProcess->contextid;
	return( PerProcess->nameserver );
      }
  }
