/*
 * creatsession.c
 * Create a session and register it with the local name server.
 *   If owner != 0, set the session's owner to be the given pid
 *
 * Tim Mann 8-4-83
 */

#include "Vnaming.h"
#include "Vsession.h"
#include "Vioprotocol.h"

#define MAX_FIELD_SIZE 32  /* liberal */
#define null(string) ((string)[0] == '\0')

SystemCode CreateSession(hostname, username, password, sessionname, owner)
    char *hostname, *username, *password, *sessionname;
    ProcessId owner;
  {
    Message msg;
    register long *msgp = (long *) msg;
#define crequest ((CreateSessionRequest *) msgp)
#define creply ((CreateSessionReply *) msgp)
#define nrequest ((ContextRequest *) msgp)
#define nreply ((ContextReply *) msgp)
#define lrequest ((LookupServerRequest *) msgp)
#define lreply ((LookupServerReply *) msgp)
#define irequest ((IoRequest *) msgp)
#define ireply ((IoReply *) msgp)
    ProcessId sessionpid, serverpid, nameserverpid;
    InstanceId sessioniid;
    char requeststring[MAX_FIELD_SIZE*3];
    int length;

    /* First check for duplicate name */
    nrequest->requestcode = GET_CONTEXT_ID;
    nrequest->namecontextid = DEFAULT_CONTEXT;
    nrequest->nameptr = sessionname;
    nrequest->namelength = strlen(sessionname);
    nrequest->nameindex = 0;
    nameserverpid = GetPid(NAME_SERVER, LOCAL_PID);
    Send(nrequest, nameserverpid);

    if (nreply->replycode == OK) return (DUPLICATE_NAME);

    /* Look up server name */
    serverpid = GetPid(UNIX_SERVER, REMOTE_PID);  /* Find someone to ask */
    if (serverpid == 0) return (SERVER_NOT_RESPONDING);
    lrequest->requestcode = LOOKUP_SERVER;
    lrequest->hostname = hostname;
    lrequest->namelength = strlen(hostname);
    Send(lrequest, serverpid);
    if (lreply->replycode != OK) return (lreply->replycode);

    serverpid = lreply->serverpid;

    /* Log in this user */
    if (null(username) || null(password)) return (NO_PERMISSION);
    length = strlen(username);
    strcpy(requeststring, username);
    strcpy(&requeststring[length+1], password);
    length += strlen(password) + 1;    

    crequest->requestcode = CREATE_INSTANCE;
    crequest->filename = requeststring;
    crequest->filenamelen = length;
    crequest->filenameindex = 0;
    crequest->contextid = DEFAULT_CONTEXT;
    crequest->type = 0;
    crequest->filemode = FCREATE|FSESSION;
    crequest->sessionowner = owner;
    Send(crequest, serverpid);
    if ( creply->replycode != OK ) return (creply->replycode);

    sessionpid = creply->fileserver;
    sessioniid = creply->fileid;

    /* Register with local name server */
    nrequest->requestcode = ADD_CONTEXT_NAME;
    nrequest->serverpid = sessionpid;
    nrequest->contextid = LOGIN_CONTEXT;
    nrequest->entrytype = SESSION;
    nrequest->instanceid = sessioniid;
    nrequest->otherinfo = 0;
    nrequest->namecontextid = DEFAULT_CONTEXT;
    nrequest->nameptr = sessionname;
    nrequest->namelength = strlen(sessionname);
    nrequest->nameindex = 0;
    Send(nrequest, nameserverpid);

    if (nreply->replycode != OK) return (nreply->replycode);

    return (OK);

#undef crequest
#undef lrequest
#undef nrequest
#undef irequest
#undef creply
#undef lreply
#undef nreply
#undef ireply
  }
