/*
 * aliasctxname.c
 * Defines a new name for a context by looking up the old name using
 *   GET_CONTEXT_ID, then adding the new name as a synonym using
 *   ADD_CONTEXT_NAME.
 *
 * Tim Mann 8-4-83
 */

#include "../include/Vnaming.h"

SystemCode AliasContextName(newname, oldname)
    char *newname, *oldname;
  {
    Message msg1, msg2;
    register ContextRequest *grequest = (ContextRequest *) msg1;
    register ContextReply *greply = (ContextReply *) msg1;
    register ContextRequest *arequest = (ContextRequest *) msg2;
    register ContextReply *areply = (ContextReply *) msg2;
    ProcessId pid;

    /* Map the existing name to a (serverpid, contextid) pair */
    grequest->requestcode = GET_CONTEXT_ID;
    grequest->nameindex = 0;
    grequest->nameptr = oldname;
    grequest->namelength = strlen(oldname);

    /* The existing name is interpreted in the current context if it
     *  does not begin with a '['; else it is sent to the local
     *  name server */
    pid = DirectToCurrentContext(grequest);
    Send(grequest, pid);

    if (greply->replycode != OK) return (greply->replycode);

    /* Add the new name as a synonym for the old */
    arequest->requestcode = ADD_CONTEXT_NAME;
    arequest->nameindex = 0;
    arequest->serverpid = greply->serverpid;
    arequest->contextid = greply->contextid;
    arequest->entrytype = 0;
    arequest->instanceid = 0;
    arequest->otherinfo = 0;
    arequest->namecontextid = DEFAULT_CONTEXT; /* Used to interpret newname */
    arequest->nameptr = newname;
    arequest->namelength = strlen(newname);

    Send(arequest, GetPid(NAME_SERVER, LOCAL_PID));

    return (areply->replycode);
  }
