/*
 * V Kernel I/O - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex I/O system)
 *
 * Write
 */

#include "Vioprotocol.h"


Write( fad, buffer, bytes ) File *fad; char *buffer; int bytes;

   /* Write the specified number of bytes from the buffer into the
    * file instance specified by fad. The number of bytes written is
    * returned.
    */
  {
    Message	msg;
    register IoRequest	*request = (IoRequest *) msg;
    register IoReply	*reply = (IoReply *) msg;
    register unsigned r, count;
    register char *buf;

    for(;;)
      {
	request->requestcode = WRITE_INSTANCE;
	request->fileid = fad->fileid;
	request->bytecount = bytes;
        request->blocknumber = fad->block;

	count = bytes;
        if ( count <= IO_MSG_BUFFER )
	  {
	    request->requestcode = WRITESHORT_INSTANCE;
	    buf = (char *) request->shortbuffer;
	    for( r = 0; r < count; ++r ) *buf++ = *buffer++;
	  }
	else request->bufferptr = buffer;

	Send( request, fad->fileserver );

	if ( (r = reply->replycode) != RETRY ) break;
      }	
    fad->lastexception = r;
    if( r == NONEXISTENT_PROCESS || r == KERNEL_TIMEOUT )
	return( 0 );
    else
	count = reply->bytecount;

    if ( (r == OK) && (fad->block >= fad->lastblock) )
      {
	fad->lastbytes = (count < fad->lastbytes) ? fad->lastbytes : count;
	fad->lastblock = fad->block;
      }
    return( count );
  }
