/*
 * OpenTcp
 * Opens a Tcp connection instance with the internet server
 *   and creates a corresponding File structure.
 *
 * Marvin Theimer, 8/83
 */

#include <Vioprotocol.h>
#include <Vnet.h>


File *OpenTcp(localPort, foreignPort, foreignHost, active,
		precedence, security, error)
    unsigned short localPort, foreignPort;
    unsigned long foreignHost;
    int active, precedence, security;
    SystemCode *error;
{
  Message m;
  CreateInstanceRequest *msg = (CreateInstanceRequest *) m;
  ProcessId netPid;
  TcpParms1 *ct;

  netPid = GetPid(INTERNET_SERVER,ANY_PID);
  msg->requestcode = CREATE_INSTANCE;
  msg->filenameindex = 0;
  msg->filename = "Tcp";
  msg->filenamelen = 3;
  msg->type = TCPtype;

  ct = (TcpParms1 *) (msg->unspecified);
  ct->localPort = localPort;
  ct->foreignPort = foreignPort;
  ct->foreignHost = foreignHost;
  ct->active = active;
  ct->precedence = precedence;
  ct->security = security;

  return(_Open(msg, FCREATE|FRELEASE_ON_CLOSE, netPid, error) );
}
