/*
 * OpenPup
 * Opens a Pup connection instance with the internet server and
 *   creates a corresponding File structure.
 *
 * Marvin Theimer, 8/83
 */

#include <Vioprotocol.h>
#include <Vnet.h>



File *OpenPup(socket, error)
    unsigned long socket;
    SystemCode *error;
{
  Message m;
  CreateInstanceRequest *msg = (CreateInstanceRequest *) m;
  ProcessId netPid;
  PupParms *ct;

  netPid = GetPid(INTERNET_SERVER,ANY_PID);
  msg->requestcode = CREATE_INSTANCE;
  msg->filenameindex = 0;
  msg->filename = "Pup";
  msg->filenamelen = 3;
  msg->type = PUPtype;

  ct = (PupParms *) (msg->unspecified);
  ct->socket = socket;

  return(_Open(msg, FCREATE|FBLOCK_MODE|FRELEASE_ON_CLOSE, netPid, error) );
}
