#include "Vio.h"

extern File *Open();

File *fopen( pathname, mode )   char *pathname; register char *mode;

  /*  Fopen opens the file specified by pathname, positioning it for
   *   read, write, or append operations, depending on the contents
   *   of mode.
   *   Mode is specified as in Unix ("r", "w", "a", "r+", "w+", "a+"),
   *   with the exception that the V library provides no "write only"
   *   mode.  Thus "w" and "w+" are equivalent here.
   */

{
   SystemCode error;
   register int readandwrite;
   File        *FileId;

   readandwrite =  mode[ 1 ] == '+';

  /*  If mode is "w", create a new instance of the file. FCREATE allows
   *  both reading from and writing to the file.
   */

   if( mode[ 0 ] == 'w' )

      FileId = Open( pathname, FCREATE, &error );

  /*  If mode is "a", position the file at its end, for both reading and
   *  writing, or for writing only.
   */

   else if( mode[ 0 ] == 'a' )
	{
	  if( readandwrite )
	     {
		FileId = Open( pathname, FMODIFY, &error );
		Seek( FileId, 0, FILE_END );
	     }
	  else
		FileId = Open( pathname, FAPPEND, &error );
	}

   /*  If the mode is "r", open the file for both reading and writing,
    *  or for reading only.
    */

   else if( mode[ 0 ] == 'r' )
	{	
	   if( readandwrite )
		FileId = Open( pathname, FMODIFY, &error );
	   else
		FileId = Open( pathname, FREAD, &error );
	}
   else
	{
           FileId = Open( pathname, FREAD, &error );
	}

   return( FileId );
}
