
#include "Vio.h"

unsigned FillBuffer( fad )  File *fad;

   /* Fill the buffer of the open file specified by fad. Return the first
    * character in the buffer or EOF.
    */

   {
      if( fad->state & EOF_BYTE )   return( EOF );

      if ((fad == stdin) && (stdout->type & INTERACTIVE))
	Flush(stdout); /* Flush standard output */

   /* If all the bytes returned in the last call to Read have been read,
    * move to the next block.
    */

      if( fad->readindex == fad->bytes && fad->type & VARIABLE_BLOCK )
        fad->readindex = fad->blocksize;

   /* Normalize the current byte position, put the file in reading mode,
    * and return the first character read or EOF.
    */

      Seek( fad, 0, REL_BYTE );

      if( fad->readindex < fad->bytes )
        return( fad->buffer[ fad->readindex++] );
      
      fad->state |= EOF_BYTE;
      return( EOF );
   }
