/*
 * CreatePipeInstance
 * Creates a pipe instance.  Does not set up File structures for it.
 *   Returns the CreateInstanceReply in pipeReq.
 *
 * Marvin Theimer, 8/83, Tim Mann, 9/83
 */

#include <Vioprotocol.h>
#include <Vpipe.h>

SystemCode CreatePipeInstance(readOwner, writeOwner, buffers, pipeReq)
    ProcessId readOwner, writeOwner;
    int buffers;
    register CreatePipeRequest *pipeReq;
  {
    CreateInstanceReply *pipeRep = (CreateInstanceReply *) pipeReq;
    ProcessId pid;

    /* Create a pipe. */
    pipeReq->requestcode = CREATE_INSTANCE;
    pipeReq->filemode = FCREATE;
    pipeReq->readowner = readOwner;
    pipeReq->writeowner = writeOwner;
    pipeReq->buffers = buffers;
    pipeReq->filename = "Pipe";
    pipeReq->filenamelen = 4;

    pid = GetPid(PIPE_SERVER, ANY_PID);
    Send(pipeReq, pid);

    return(pipeRep->replycode);
  }

