/*
 * V Kernel I/O - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex I/O system)
 *
 * Close and SpecialClose
 */

#include "Vioprotocol.h"


Close( fad )
    File *fad;
  {
    SpecialClose( fad, OK );
  }



SpecialClose( fad, mode )
    register File *fad;
    short unsigned mode;

  /* Flush the file, release the file instance if indicated in
   * the fad structure, free memory used for the buffer and fad.
   */
  {
    extern File *TeamFileList;
    Message Msg;
    register IoRequest *request = (IoRequest *)Msg;
    register File *p, *c;

    if ( fad == TeamFileList ) TeamFileList = fad->link;
    else
      {
	p = TeamFileList;
	while( ((c = p->link) != NULL ) && (c != fad) ) p = c;
        if ( c == NULL ) return;

	p->link = c->link;
      }
    Flush( fad );

    if ( fad->type & FRELEASE_ON_CLOSE )
      {
	request->requestcode = RELEASE_INSTANCE;
	request->fileid = fad->fileid;
	request->releasemode = mode;

	Send( request, fad->fileserver );
      }
    if ( fad->buffer && fad->fileserver ) free( fad->buffer );

    free( fad );
  }


