/*
* V - Copright 1982 (c) David Cheriton, all rights reserved.
*
*   Network server manifests, struct and type definitions.
*
*/

#ifndef VNET
#define VNET


/* Connection types.
*  These go into the "filetype" field of a CREATE_INSTANCE request. 
*/
#define IPtype 0
#define TCPtype 1
#define PUPtype 2


/* Release Request Types
*/  
#define REL_STANDARD		0
#define REL_ABORT		203    	/*  Only used to abort TCP */


/* ModifyFile parameter specifications
*/
#define ModTcpTimeout 0
#define ModTcpUrgFlag 1


/* Default Tcp instance parameters
*/
#define DefaultTcpPrecedence 0
#define DefaultTcpSecurity 0

/* Tcp connection instance "special" events.
*/
#define UrgentData 0x8002		/* Signals that urgent data is 
					   present. */



/*
*    TYPE DEFINITIONS
*/

/* Request & Reply Message Formats
*/
typedef struct				/*  Network Server Modify File */
  {					/* Request message format */
    SystemCode requestcode;
    InstanceId fileid;
    unsigned short whichParm;		/* Indicates which parameter should
					   be modified. */
    unsigned unspecified[6];
  } ModifyFileRequest;

typedef struct				/* Query file Request message */
  {					/* format.*/
    SystemCode requestcode;
    InstanceId fileid;
    unsigned short whichParms;		/* Indicates which parameters should
					   be returned. */
    unsigned unspecified[6];
  } QueryFileRequest;


/* Parameter record formats for the various protocols
*/

typedef struct				/* IP protocol parameters */
  {
    char protocol;
  } IpParms;


typedef struct				/* TCP parameters set in the
					   CreateInstance call. */
  {
    short unsigned localPort,
		   foreignPort;
    long unsigned foreignHost;
    unsigned short active;
    short security;
    short precedence;
  } TcpParms1;

typedef struct				/* TCP parameters which normally
					   receive default values, and also
					   various state information
					   parameters. */
  {
    short timeout;
    unsigned short sndUrgFlag, rcvUrgFlag;
    short bytesAvail;
    short state;
  } TcpParms2;

typedef struct				/* PUP protocol parameters */
  {
    unsigned long socket;
  } PupParms;

#endif VNET
