/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Vdirectory.h
 *
 * Include file defining the standard context directory entry formats
 *   and message types
 */

#ifndef VDIRECTORY
#define VDIRECTORY

/* Message types */
typedef struct
  {
    SystemCode		requestcode;
    short unsigned	nameindex;	/* Start of name within segment */
    InstanceId		fileid;
    short unsigned	dataindex;	/* Start of data within segment */
    unsigned		filler[3];
    ContextId		namecontextid;	/* Context used to interpret name */
    char		*segmentptr;
    unsigned		segmentlen;
  } DescriptorRequest;
    

typedef struct
  {
    SystemCode		replycode;
    short unsigned	filler1[2];
    short unsigned	dataindex;	/* Start of data within segment */
    unsigned		filler2[4];
    char		*segmentptr;
    unsigned		segmentlen;
  } DescriptorReply;

/* Descriptor type flags */
#define EMPTY_DESCRIPTOR	0
#define FILE_DESCRIPTOR		1
#define DEVICE_DESCRIPTOR	2
#define LOCALNAME_DESCRIPTOR	3
#define TEAM_DESCRIPTOR		4
#define UNIXFILE_DESCRIPTOR	5
#define VGT_DESCRIPTOR		6

/* Empty descriptor (unused directory slot) */
typedef struct
  {
    unsigned		descriptortype; /* This field must be the first
					 *   one in each descriptor struct */
  } EmptyDescriptor;

/* File on a V storage server */
typedef struct
  {
    unsigned		descriptortype;
    /* not specified yet */
  } FileDescriptor;


/* File on the UNIX server */
#define UnixFileNameLen		14	/* should be included from UNIX */
#define UnixUserNameLen		8	/* ditto */
typedef struct
  {
    unsigned		descriptortype;
    char		name[UnixFileNameLen + 2]; /* name in directory */
						   /* +2 is to ease byte
						      swapping */
    /* The following fields are direct copies of the entries in
       "struct stat" in the UNIX include file <stat.h>. */
    short		st_dev;			/* (major,minor) device #s */
    unsigned short 	st_ino;			/* inode number */
    unsigned short	st_mode;		/* protection bits for file */
    short		st_nlink;		/* # of directory entries 
    						   for this object */
    short		st_uid;		        /* unix user number of owner */
    short		st_gid;			/* group "owner" of file */
    short		st_rdev;		/* raw device # */
    short		alignment2;		/* needed for BS */
    long		st_size;		/* number of bytes in file */

    /* NOTE: the following times are from Jan 1, 1970 */
    long 		st_atime;		/* time of last	access */
    long		st_mtime;		/* last modification */
    long		st_ctime;		/* creation date */

    char		ownername[UnixUserNameLen];	/* userid expanded */
    char		groupname[UnixUserNameLen];	/* groupid expanded */
  } UnixFileDescriptor;

/* Local name server entries */
/* Warning: some code in the local name server may depend on the first
 *   few fields in these two types being identical */
#define NameServerNameLen	16

/* - Context name */
typedef struct
  {
    unsigned		descriptortype;
    char		name[NameServerNameLen]; /* Name of this entry */
    short unsigned	entrytype;
    InstanceId		instanceid;	/* Associated instance if any */
    ProcessId		serverpid;	/* Name server for this context */
    ContextId		contextid;	/* Context id for this context */
    unsigned	    	otherinfo;	/* Other info passed by client */
  } LocalNameDescriptor;

/* - Kernel device */
typedef struct
  {
    unsigned		descriptortype;
    char		name[NameServerNameLen]; /* Name of this entry */
    short unsigned	entrytype;
    short unsigned	devicetype;	/* type field for CreateInstance */
    unsigned		unspecified0;	/* unspecified0 field */
  } DeviceDescriptor;


/* Team server */
#define TeamFileNameLength 40

typedef struct
  {
    unsigned	descriptortype;
    char	fileName[TeamFileNameLength];
    ProcessId 	ownerPid;
    ProcessId	rootPid;
    ProcessId	fileserver;
    InstanceId	fileid;
  } TeamDescriptor;



/* Virtual Graphics Terminal server */
#define VgtNameLength 64
#define VgtBannerLength 128

typedef struct
  {
    unsigned	descriptortype;
    char	name[VgtNameLength];
    char	banner[VgtBannerLength];
    int		typeVGT;
    int		mode;
    short	vgt, master;
    short	lines, columns;
    ProcessId 	ownerPid;
    ProcessId	breakPid;
    InstanceId	fileid;
  } VgtDescriptor;


/* Arbitrary descriptor */
typedef union
  {
    EmptyDescriptor	e;
    FileDescriptor	f;
    DeviceDescriptor	d;
    LocalNameDescriptor	n;
    TeamDescriptor	t;
    UnixFileDescriptor	u;
    VgtDescriptor	v;
  } ArbitraryDescriptor;

#endif VDIRECTORY
