/*
 * ValidProgram:
 * Checks whether the file specified by filename represents a valid program
 * that can be run on the local host.  Returns a pointer to a File structure
 * if it is a valid program.
 */

#include <Vteams.h>
#include <b.out.h>

File *ValidProgram(filename, errcode)
    char *filename;
    SystemCode *errcode;
  {
    File *teamfile;
    int rsize;
    struct bhdr header;
    
    teamfile = Open(filename, FREAD | FBLOCK_MODE, errcode);
    if( *errcode || (teamfile == NULL) )
	return (NULL);

    /* Read b.out header */
    /* We assume blocks are at least this big, or the server
     *   supports multi-block reads */
    rsize = Read(teamfile, &header, sizeof(header));

    if( rsize < sizeof(header) )
      { 
	Close(teamfile);
	*errcode = END_OF_FILE;
	return(NULL);
      }

    /* Check the header has the legal magic number */
    if( header.fmagic != FMAGIC )
      {
	Close(teamfile);
	*errcode = BAD_STATE;
	return(NULL);
      }
    *errcode = OK;

    return(teamfile);
  }
