/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * ParseLine:
 * Parse a command line into arguments.
 * Take the raw buffer and construct an array of pointers
 * into it, null terminating each word.
 * Skip over leading blanks and tabs
 * at the beginning.
 *
 * Marvin Theimer, 7/83
 *	Made into a separate library routine.
 */


#include <Venviron.h>
#include <chars.h>


ParseLine(start,args, maxArgs)
    char *start;
    char *args[];
    int maxArgs;
  {
    register char *p = start;
    int argc = 0;

    while ((*p == ' ') || (*p == TAB))
				/* Skip over leading blanks and tabs. */
	p++;
    while (*p)
      {
        *args++ = p;
        if (argc++ == maxArgs - 2) break;
	while (*p && *p!=' ' && *p!=TAB) p++;
	while (*p && (*p==' ' || *p==TAB) ) *p++ = 0;
      }
    *args = NULL;
    return(argc);
  }
